/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.soap;

import weblogic.auddi.soap.SAAJTransport;
import weblogic.auddi.soap.SOAPTransport;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;

class SOAPTransportFactory {
    private static final String SOAP_TRANSPORT_TYPE = "acumenat.soap.transport.type";
    private static final String WLS_SAAJ_MESSAGEFACTORY_CLASS = "weblogic.webservice.core.soap.MessageFactoryImpl.class";
    private static final String WLS_SAAJ_CONNECTIONFACTORY_CLASS = "weblogic.webservice.core.soap.ConnectionFactoryImpl.class";
    private static final String WLS_SAAJ_SOAPFACTORY_CLASS = "weblogic.webservice.core.soap.SOAPFactoryImpl.class";
    private static final String ACUMEN_SAAJ_MESSAGEFACTORY_CLASS = "acumenat.saaj.MessageFactory.class";
    private static final String ACUMEN_SAAJ_CONNECTIONFACTORY_CLASS = "acumenat.saaj.ConnectionFactory.class";
    private static final String ACUMEN_SAAJ_SOAPFACTORY_CLASS = "acumenat.saaj.SOAPFactory.class";

    private SOAPTransportFactory() {
    }

    public static SOAPTransport getSOAPTransport() {
        Logger.trace("+weblogic.auddi.soap.SOAPTransportFactory.getSOAPTransport()");
        String string = PropertyManager.getRuntimeProperty(SOAP_TRANSPORT_TYPE);
        Logger.trace("transportType : " + string);
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("SAAJ")) {
            String string2 = PropertyManager.getRuntimeProperty(WLS_SAAJ_MESSAGEFACTORY_CLASS);
            String string3 = PropertyManager.getRuntimeProperty(WLS_SAAJ_CONNECTIONFACTORY_CLASS);
            String string4 = PropertyManager.getRuntimeProperty(WLS_SAAJ_SOAPFACTORY_CLASS);
            if (string2 == null) {
                string2 = PropertyManager.getRuntimeProperty(ACUMEN_SAAJ_MESSAGEFACTORY_CLASS);
                string3 = PropertyManager.getRuntimeProperty(ACUMEN_SAAJ_CONNECTIONFACTORY_CLASS);
                string4 = PropertyManager.getRuntimeProperty(ACUMEN_SAAJ_SOAPFACTORY_CLASS);
            }
            SAAJTransport sAAJTransport = new SAAJTransport(string2, string3, string4);
            Logger.trace("-weblogic.auddi.soap.SOAPTransportFactory.getSOAPTransport() returning SAAJTransport");
            return sAAJTransport;
        }
        try {
            Class<?> clazz = Class.forName(string);
            SOAPTransport sOAPTransport = (SOAPTransport)clazz.newInstance();
            Logger.trace("-weblogic.auddi.soap.SOAPTransportFactory.getSOAPTransport() returning " + string);
            return sOAPTransport;
        }
        catch (Exception exception) {
            Logger.error(exception);
            throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string));
        }
    }
}

