/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import weblogic.auddi.uddi.AuthTokenExpiredException;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.AuthInfo;
import weblogic.auddi.uddi.request.UDDIRequest;
import weblogic.auddi.uddi.request.publish.GetAuthTokenRequest;
import weblogic.auddi.uddi.request.publish.UDDIPublishRequest;
import weblogic.auddi.uddi.response.AuthTokenResponse;
import weblogic.auddi.uddi.response.DispositionReportResponse;
import weblogic.auddi.uddi.response.ErrorDispositionReportResponse;
import weblogic.auddi.uddi.response.FaultResponse;
import weblogic.auddi.uddi.response.UDDIResponse;
import weblogic.auddi.uddi.soap.SOAPClient;
import weblogic.auddi.uddi.soap.UDDISOAPWrapper;
import weblogic.auddi.uddi.util.UDDIExceptionMapper;
import weblogic.auddi.uddi.xml.ParserWrapper;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.util.Util;
import weblogic.auddi.xml.SchemaException;

public class UDDIProxy {
    private URL m_inquiryURL = null;
    private URL m_publishURL = null;
    private String m_proxyHost = null;
    private int m_proxyPort = -1;
    private String m_username = null;
    private String m_password = null;
    private AuthInfo m_authinfo = null;
    public static final int ERROR = 0;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int TRACE = 4;

    private void initialize() {
        PropertyManager.setRuntimeProperty("uddi.schema.resource", "/weblogic/auddi/uddi/resources/uddi_v2.xsd");
        PropertyManager.setRuntimeProperty("soap.schema.resource", "/weblogic/auddi/uddi/resources/soap-envelope.xml");
        PropertyManager.setRuntimeProperty("xml.schema.resource", "/weblogic/auddi/uddi/resources/xml.xml");
        PropertyManager.setRuntimeProperty("xml.parser.class", "weblogic.auddi.xml.UDDIParser");
        String string = "com.sun.net.ssl.internal.www.protocol";
        String string2 = System.getProperty("java.protocol.handler.pkgs");
        if (string2 == null) {
            string2 = string;
        } else if (string2.indexOf(string) == -1) {
            string2 = string + "|" + string2;
        }
        System.setProperty("java.protocol.handler.pkgs", string2);
    }

    public UDDIProxy() {
        this.initialize();
    }

    public static void setTrustedKeyStore(String string) {
        System.setProperty("javax.net.ssl.trustStore", string);
    }

    public void setDebugLevel(int n) {
        Logger.instance().setTraceLevel(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublishURL(String string) throws MalformedURLException {
        try {
            Logger.trace("+UDDIProxy.setPublishURL()");
            this.m_publishURL = new URL(string);
        }
        finally {
            Logger.trace("-UDDIProxy.setPublishURL()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInquiryURL(String string) throws MalformedURLException {
        try {
            Logger.trace("+UDDIProxy.setInquiryURL()");
            this.m_inquiryURL = new URL(string);
        }
        finally {
            Logger.trace("-UDDIProxy.setInquiryURL()");
        }
    }

    public void setProxy(String string, int n) {
        this.m_proxyHost = string;
        this.m_proxyPort = n;
    }

    public void setCredential(String string, String string2) {
        Logger.trace("+UDDIProxy.setCredential()");
        this.m_username = string;
        this.m_password = string2;
        this.m_authinfo = null;
        Logger.trace("-UDDIProxy.setCredential()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() throws UDDIException {
        try {
            Logger.trace("+UDDIProxy.authenticate()");
            GetAuthTokenRequest getAuthTokenRequest = new GetAuthTokenRequest(this.m_username, this.m_password);
            AuthTokenResponse authTokenResponse = (AuthTokenResponse)this.execute(getAuthTokenRequest);
            this.m_authinfo = authTokenResponse.getAuthInfo();
        }
        finally {
            Logger.trace("-UDDIProxy.authenticate()");
        }
    }

    private void setAuthInfo(UDDIPublishRequest uDDIPublishRequest) throws UDDIException {
        if (this.m_authinfo == null) {
            this.authenticate();
        }
        uDDIPublishRequest.setAuthInfo(this.m_authinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDIResponse execute(UDDIRequest uDDIRequest) throws UDDIException {
        try {
            Logger.trace("+UDDIProxy.execute(UDDIRequest)");
            URL uRL = this.m_inquiryURL;
            if (uDDIRequest instanceof UDDIPublishRequest || uDDIRequest instanceof GetAuthTokenRequest) {
                uRL = this.m_publishURL;
            }
            UDDIResponse uDDIResponse = this.execute(uDDIRequest, uRL);
            return uDDIResponse;
        }
        finally {
            Logger.trace("-UDDIProxy.execute(UDDIRequest)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDIResponse execute(UDDIRequest uDDIRequest, String string) throws MalformedURLException, UDDIException {
        try {
            UDDIResponse uDDIResponse;
            Logger.trace("+UDDIProxy.execute(UDDIRequest, String)");
            URL uRL = new URL(string);
            UDDIResponse uDDIResponse2 = uDDIResponse = this.execute(uDDIRequest, uRL);
            return uDDIResponse2;
        }
        finally {
            Logger.trace("-UDDIProxy.execute(UDDIRequest, String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDDIResponse execute(UDDIRequest uDDIRequest, URL uRL) throws UDDIException {
        try {
            Object object;
            Logger.trace("+UDDIProxy.execute(UDDIRequest, URL)");
            if (uDDIRequest instanceof UDDIPublishRequest && (((UDDIPublishRequest)(object = (UDDIPublishRequest)uDDIRequest)).getAuthInfo() == null || ((UDDIPublishRequest)object).getAuthInfo().getValue() == null || ((UDDIPublishRequest)object).getAuthInfo().getValue().equals("") || ((UDDIPublishRequest)object).getAuthInfo().getValue().equals("$$auth_token$$"))) {
                this.setAuthInfo((UDDIPublishRequest)object);
            }
            object = uDDIRequest.toSOAP();
            UDDIResponse uDDIResponse = null;
            try {
                uDDIResponse = this.sendRequest((String)object, uRL);
            }
            catch (AuthTokenExpiredException authTokenExpiredException) {
                if (this.m_username == null) {
                    throw authTokenExpiredException;
                }
                this.m_authinfo = null;
                this.setAuthInfo((UDDIPublishRequest)uDDIRequest);
                uDDIResponse = this.sendRequest((String)object, uRL);
            }
            UDDIResponse uDDIResponse2 = uDDIResponse;
            return uDDIResponse2;
        }
        finally {
            Logger.trace("-UDDIProxy.execute(UDDIRequest, URL)");
        }
    }

    private UDDIResponse sendRequest(String string, URL uRL) throws UDDIException {
        try {
            String string2 = null;
            Logger.debug("UDDIProxy attempting to send\n[" + string + "]\n");
            string2 = this.m_proxyHost == null ? SOAPClient.sendUDDIRequest(uRL, string) : SOAPClient.sendUDDIRequest(uRL, this.m_proxyHost, this.m_proxyPort, string);
            Logger.debug("UDDIProxy received in return the following RAW response:\n[" + string2 + "]\n");
            UDDIResponse uDDIResponse = UDDISOAPWrapper.createResponseFromSOAP(string2);
            this.handleErrorDispositions(uDDIResponse);
            if (uDDIResponse instanceof FaultResponse) {
                Logger.debug("A FaultResponse was received");
                FaultResponse faultResponse = (FaultResponse)uDDIResponse;
                DispositionReportResponse dispositionReportResponse = faultResponse.getDisposition();
                this.handleErrorDispositions(dispositionReportResponse);
                uDDIResponse = dispositionReportResponse;
            }
            return uDDIResponse;
        }
        catch (IOException iOException) {
            throw new FatalErrorException("Error sending request", iOException);
        }
    }

    private void handleErrorDispositions(UDDIResponse uDDIResponse) throws UDDIException {
        if (uDDIResponse instanceof ErrorDispositionReportResponse) {
            Logger.debug("An ErrorDispositionReportResponse was received");
            ErrorDispositionReportResponse errorDispositionReportResponse = (ErrorDispositionReportResponse)uDDIResponse;
            UDDIException uDDIException = UDDIExceptionMapper.toException(errorDispositionReportResponse);
            throw uDDIException;
        }
    }

    public UDDIResponse processRequestFile(String string) throws UDDIException {
        try {
            UDDIResponse uDDIResponse;
            Logger.trace("+UDDIProxy.processRequestFile()");
            String string2 = Util.getFileContent(string);
            UDDIResponse uDDIResponse2 = uDDIResponse = this.processRequestString(string2);
            return uDDIResponse2;
        }
        catch (IOException iOException) {
            throw new FatalErrorException("Error reading request from file: " + string, iOException);
        }
        finally {
            Logger.trace("-UDDIProxy.processRequestFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDIResponse processRequestString(String string) throws UDDIException {
        try {
            UDDIResponse uDDIResponse;
            Logger.trace("+UDDIProxy.processRequestString()");
            UDDIRequest uDDIRequest = UDDISOAPWrapper.createRequest(string);
            UDDIResponse uDDIResponse2 = uDDIResponse = this.execute(uDDIRequest);
            return uDDIResponse2;
        }
        finally {
            Logger.trace("-UDDIProxy.processRequestString()");
        }
    }

    public boolean isValidRequest(UDDIRequest uDDIRequest) {
        if (uDDIRequest != null) {
            try {
                String string = uDDIRequest.toSOAP();
                ParserWrapper.parseRequest(string, true);
            }
            catch (SchemaException schemaException) {
                Logger.error(schemaException);
                return false;
            }
            catch (UDDIException uDDIException) {
                Logger.error(uDDIException);
                return false;
            }
            return true;
        }
        return false;
    }

    private static void usage() {
        System.err.println("Usage:  java " + UDDIProxy.class.getName() + " <server_url> <filename_for_uddi_request> [<userid> <password>]");
        System.err.println("and set proxy information, if any, by passing -Dauddi.proxyHost=<proxyHost> -Dauddi.proxyPort=<proxyPort>");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 4) {
            UDDIProxy.usage();
        }
        UDDIProxy uDDIProxy = new UDDIProxy();
        String string = System.getProperty("logger.verbosity");
        if (string != null) {
            if (string.equalsIgnoreCase("trace")) {
                uDDIProxy.setDebugLevel(4);
            } else if (string.equalsIgnoreCase("debug")) {
                uDDIProxy.setDebugLevel(3);
            } else if (string.equalsIgnoreCase("info")) {
                uDDIProxy.setDebugLevel(2);
            } else if (string.equalsIgnoreCase("error")) {
                uDDIProxy.setDebugLevel(0);
            } else {
                uDDIProxy.setDebugLevel(0);
            }
        }
        switch (stringArray.length) {
            case 3: {
                uDDIProxy.setCredential(stringArray[2], "");
                break;
            }
            case 4: {
                uDDIProxy.setCredential(stringArray[2], stringArray[3]);
            }
        }
        String string2 = System.getProperty("auddi.proxyHost");
        String string3 = System.getProperty("auddi.proxyPort");
        if (string2 != null && string3 != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                System.err.println("\nThe <auddi.proxyPort> value [" + string3 + "] is not a valid number.");
                System.exit(1);
            }
            uDDIProxy.setProxy(string2, n);
            Logger.info("Proxy values set to host " + string2 + " and port " + n);
        } else {
            Logger.debug("Proxy values not set");
        }
        uDDIProxy.setInquiryURL(stringArray[0]);
        uDDIProxy.setPublishURL(stringArray[0]);
        UDDIResponse uDDIResponse = null;
        try {
            uDDIResponse = uDDIProxy.processRequestFile(stringArray[1]);
        }
        catch (UDDIException uDDIException) {
            uDDIResponse = UDDIExceptionMapper.toDispositionReport(uDDIException);
        }
        String string4 = null;
        if (uDDIResponse != null) {
            string4 = uDDIResponse.toXML();
        }
        System.out.println("Response:\n\n\n" + string4 + "\n");
    }
}

