/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.client;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.client.UDDIProxy;
import weblogic.auddi.uddi.datastructure.AccessPoint;
import weblogic.auddi.uddi.datastructure.BindingTemplate;
import weblogic.auddi.uddi.datastructure.BindingTemplates;
import weblogic.auddi.uddi.datastructure.BusinessEntities;
import weblogic.auddi.uddi.datastructure.BusinessEntity;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.BusinessService;
import weblogic.auddi.uddi.datastructure.BusinessServices;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.DiscoveryURL;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.OverviewDoc;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelBag;
import weblogic.auddi.uddi.datastructure.TModelInstanceInfo;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.datastructure.UDDIList;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.request.UDDIRequest;
import weblogic.auddi.uddi.request.inquiry.FindBindingRequest;
import weblogic.auddi.uddi.request.inquiry.FindServiceRequest;
import weblogic.auddi.uddi.request.publish.SaveBusinessRequest;
import weblogic.auddi.uddi.request.publish.SaveServiceRequest;
import weblogic.auddi.uddi.request.publish.SaveTModelRequest;
import weblogic.auddi.uddi.response.BindingDetailResponse;
import weblogic.auddi.uddi.response.BusinessDetailResponse;
import weblogic.auddi.uddi.response.ServiceDetailResponse;
import weblogic.auddi.uddi.response.ServiceInfo;
import weblogic.auddi.uddi.response.ServiceInfos;
import weblogic.auddi.uddi.response.ServiceListResponse;
import weblogic.auddi.uddi.response.TModelDetailResponse;

public class WebServiceHelper {
    private UDDIProxy uddiProxy;

    public WebServiceHelper(String string, String string2, String string3, String string4) throws MalformedURLException, UDDIException {
        if (string == null && string2 == null) {
            throw new FatalErrorException("At minimum, a uddiInquiryURL or uddiPublishURL is needed to use the UDDI registry");
        }
        this.uddiProxy = new UDDIProxy();
        if (string != null) {
            this.uddiProxy.setInquiryURL(string);
        }
        if (string2 != null) {
            this.uddiProxy.setPublishURL(string2);
        }
        this.uddiProxy.setCredential(string3, string4);
    }

    public TModelKey saveInterface(String string, String string2, String string3) throws UDDIException {
        Serializable serializable;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Cannot save interface with no name");
        }
        TModel tModel = new TModel();
        tModel.setName(new Name(string));
        if (string2 != null) {
            serializable = new Description(string2);
            tModel.addDescription((Description)serializable);
        }
        if (string3 != null) {
            serializable = new OverviewDoc();
            ((OverviewDoc)serializable).setOverviewURL(string3);
            tModel.setOverviewDoc((OverviewDoc)serializable);
        }
        serializable = new SaveTModelRequest();
        ((SaveTModelRequest)serializable).addTModel(tModel);
        TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)this.uddiProxy.execute((UDDIRequest)((Object)serializable));
        if (tModelDetailResponse == null) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        TModels tModels = tModelDetailResponse.getTModels();
        if (tModels.size() == 0) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        TModel tModel2 = tModels.getFirst();
        TModelKey tModelKey = tModel2.getTModelKey();
        return tModelKey;
    }

    public ServiceKey saveWebService(BusinessKey businessKey, String string, String string2, String string3, TModelKey tModelKey) throws UDDIException {
        if (businessKey == null) {
            throw new IllegalArgumentException("Cannot save Web Service when no provider is specified");
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Cannot save Web Service with no name");
        }
        BusinessService businessService = this.getService(string, string2, string3, tModelKey);
        businessService.setBusinessKey(businessKey);
        SaveServiceRequest saveServiceRequest = new SaveServiceRequest();
        saveServiceRequest.addBusinessService(businessService);
        ServiceDetailResponse serviceDetailResponse = (ServiceDetailResponse)this.uddiProxy.execute(saveServiceRequest);
        if (serviceDetailResponse == null) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        BusinessServices businessServices = serviceDetailResponse.getBusinessServices();
        if (businessServices.size() == 0) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        BusinessService businessService2 = businessServices.getFirst();
        ServiceKey serviceKey = businessService2.getServiceKey();
        return serviceKey;
    }

    public ServiceKey saveWebService(String string, String string2, String string3, String string4, TModelKey tModelKey) throws UDDIException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Cannot save Web Service when no provider is specified");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Cannot save Web Service with no name");
        }
        BusinessService businessService = this.getService(string2, string3, string4, tModelKey);
        BusinessEntity businessEntity = new BusinessEntity();
        businessEntity.addName(new Name(string));
        businessEntity.addBusinessService(businessService);
        SaveBusinessRequest saveBusinessRequest = new SaveBusinessRequest();
        saveBusinessRequest.addBusinessEntity(businessEntity);
        BusinessDetailResponse businessDetailResponse = (BusinessDetailResponse)this.uddiProxy.execute(saveBusinessRequest);
        if (businessDetailResponse == null) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        BusinessEntities businessEntities = businessDetailResponse.getBusinessEntities();
        if (businessEntities.size() == 0) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        BusinessServices businessServices = businessEntities.getFirst().getBusinessServices();
        if (businessServices.size() == 0) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        BusinessService businessService2 = businessServices.getFirst();
        ServiceKey serviceKey = businessService2.getServiceKey();
        return serviceKey;
    }

    private BusinessService getService(String string, String string2, String string3, TModelKey tModelKey) throws UDDIException {
        Object object;
        UDDIListObject uDDIListObject;
        BusinessService businessService = new BusinessService();
        businessService.addName(new Name(string));
        if (string2 != null) {
            uDDIListObject = new Description(string2);
            businessService.addDescription((Description)uDDIListObject);
        }
        uDDIListObject = null;
        if (string3 != null) {
            if (uDDIListObject == null) {
                uDDIListObject = new BindingTemplate();
            }
            try {
                object = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new FatalErrorException("AccessPoint value was not a valid URL", malformedURLException);
            }
            object = string3.substring(0, 5).toLowerCase();
            String string4 = null;
            if (((String)object).startsWith("http")) {
                string4 = "http";
            } else if (((String)object).startsWith("https")) {
                string4 = "https";
            } else if (((String)object).startsWith("mailto")) {
                string4 = "mailto";
            } else {
                throw new FatalErrorException("Unrecognized accessPoint type");
            }
            AccessPoint accessPoint = new AccessPoint(string4, string3);
            ((BindingTemplate)uDDIListObject).setAccessPoint(accessPoint);
        }
        if (tModelKey != null) {
            if (uDDIListObject == null) {
                uDDIListObject = new BindingTemplate();
            }
            object = new TModelInstanceInfo(tModelKey);
            ((BindingTemplate)uDDIListObject).addTModelInstanceInfo((TModelInstanceInfo)object);
        }
        if (uDDIListObject != null) {
            businessService.addBindingTemplate((BindingTemplate)uDDIListObject);
        }
        return businessService;
    }

    public BusinessKey saveServiceProvider(String string, String string2, String string3) throws UDDIException {
        UDDIListObject uDDIListObject;
        Object object;
        Object object2;
        Serializable serializable;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Cannot save Web Service Provider without a name");
        }
        BusinessEntity businessEntity = new BusinessEntity();
        businessEntity.addName(new Name(string));
        if (string2 != null) {
            serializable = new Description(string2);
            businessEntity.addDescription((Description)serializable);
        }
        if (string3 != null) {
            serializable = null;
            try {
                serializable = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new FatalErrorException("DiscoveryURL value was not a valid URL", malformedURLException);
            }
            object2 = string3.substring(0, 5).toLowerCase();
            object = null;
            if (((String)object2).startsWith("http")) {
                object = "http";
            } else if (((String)object2).startsWith("https")) {
                object = "https";
            } else if (((String)object2).startsWith("mailto")) {
                object = "mailto";
            } else {
                throw new FatalErrorException("Unrecognized discoveryURL type");
            }
            uDDIListObject = new DiscoveryURL((String)object, string3);
            businessEntity.addDiscoveryURL((DiscoveryURL)uDDIListObject);
        }
        serializable = new SaveBusinessRequest();
        ((SaveBusinessRequest)serializable).addBusinessEntity(businessEntity);
        object2 = (BusinessDetailResponse)this.uddiProxy.execute((UDDIRequest)((Object)serializable));
        if (object2 == null) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        object = ((BusinessDetailResponse)object2).getBusinessEntities();
        if (((UDDIList)object).size() == 0) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        uDDIListObject = ((BusinessEntities)object).getFirst();
        BusinessKey businessKey = uDDIListObject.getBusinessKey();
        return businessKey;
    }

    public ServiceInfos findWebServiceImplementations(TModelKey tModelKey) throws UDDIException {
        if (tModelKey == null) {
            throw new IllegalArgumentException("A TModelKey is required for this operation");
        }
        FindServiceRequest findServiceRequest = new FindServiceRequest();
        TModelBag tModelBag = new TModelBag();
        tModelBag.add(tModelKey);
        findServiceRequest.setTModelBag(tModelBag);
        ServiceListResponse serviceListResponse = (ServiceListResponse)this.uddiProxy.execute(findServiceRequest);
        if (serviceListResponse == null) {
            throw new FatalErrorException("Operation failed - no response received from the server");
        }
        ServiceInfos serviceInfos = serviceListResponse.getServiceInfos();
        return serviceInfos;
    }

    public List findInvocationPoints(TModelKey tModelKey) throws UDDIException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceInfos serviceInfos = this.findWebServiceImplementations(tModelKey);
        if (serviceInfos == null || serviceInfos.size() == 0) {
            return null;
        }
        FindBindingRequest findBindingRequest = new FindBindingRequest();
        TModelBag tModelBag = new TModelBag();
        tModelBag.add(tModelKey);
        findBindingRequest.setTModelBag(tModelBag);
        ServiceInfo serviceInfo = serviceInfos.getFirst();
        while (serviceInfo != null) {
            BindingTemplates bindingTemplates;
            findBindingRequest.setServiceKey(serviceInfo.getServiceKey());
            BindingDetailResponse bindingDetailResponse = (BindingDetailResponse)this.uddiProxy.execute(findBindingRequest);
            if (bindingDetailResponse != null && (bindingTemplates = bindingDetailResponse.getBindingTemplates()).size() > 0) {
                BindingTemplate bindingTemplate = bindingTemplates.getFirst();
                while (bindingTemplate != null) {
                    AccessPoint accessPoint = bindingTemplate.getAccessPoint();
                    if (accessPoint != null) {
                        arrayList.add(accessPoint.getURL());
                    }
                    bindingTemplate = bindingTemplates.getNext();
                }
            }
            serviceInfo = serviceInfos.getNext();
        }
        return arrayList;
    }

    public static void setTrustedKeyStore(String string) {
        UDDIProxy.setTrustedKeyStore(string);
    }
}

