/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.UnsupportedException;
import weblogic.auddi.uddi.datastructure.UDDIElement;
import weblogic.auddi.util.Util;

public class AccessPoint
extends UDDIElement
implements Serializable {
    public static final String ACCESS_POINT_MAILTO = "mailto";
    public static final String ACCESS_POINT_HTTP = "http";
    public static final String ACCESS_POINT_HTTPS = "https";
    public static final String ACCESS_POINT_FTP = "ftp";
    public static final String ACCESS_POINT_FAX = "fax";
    public static final String ACCESS_POINT_PHONE = "phone";
    public static final String ACCESS_POINT_OTHER = "other";
    private String m_urlType = null;
    private String m_url = null;

    public AccessPoint(String string, String string2) throws UDDIException {
        if (!(string.equals(ACCESS_POINT_MAILTO) || string.equals(ACCESS_POINT_HTTP) || string.equals(ACCESS_POINT_HTTPS) || string.equals(ACCESS_POINT_FTP) || string.equals(ACCESS_POINT_FAX) || string.equals(ACCESS_POINT_PHONE) || string.equals(ACCESS_POINT_OTHER))) {
            throw new UnsupportedException(UDDIMessages.get("error.unsupported.type", "URLType", string));
        }
        this.m_urlType = string;
        this.m_url = this.truncateString(string2, 255);
        try {
            int n;
            if (string.equals(ACCESS_POINT_FTP) || string.equals(ACCESS_POINT_HTTP) || string.equals(ACCESS_POINT_HTTPS)) {
                URL uRL = new URL(this.m_url);
            } else if (string.equals(ACCESS_POINT_MAILTO) && (n = this.m_url.indexOf("@")) == -1) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.malformedURL", this.m_url), malformedURLException);
        }
    }

    public AccessPoint(AccessPoint accessPoint) {
        if (accessPoint == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_urlType = accessPoint.m_urlType;
        this.m_url = accessPoint.m_url;
    }

    public String getURL() {
        return this.m_url;
    }

    public String getUrlType() {
        return this.m_urlType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccessPoint)) {
            return false;
        }
        AccessPoint accessPoint = (AccessPoint)object;
        return Util.isEqual(this.m_url, accessPoint.m_url) && Util.isEqual(this.m_urlType, accessPoint.m_urlType);
    }

    public int hashCode() {
        return Util.hashCode(this.m_url) ^ Util.hashCode(this.m_urlType);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("accessPoint");
        if (this.m_urlType != null) {
            stringBuffer.append(" URLType=\"").append(this.m_urlType).append("\"");
        }
        stringBuffer.append(">");
        if (this.m_url != null) {
            stringBuffer.append(this.fixStringForXML(this.m_url));
        }
        stringBuffer.append("</").append("accessPoint").append(">");
        return stringBuffer.toString();
    }
}

