/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.AddressLine;
import weblogic.auddi.uddi.datastructure.AddressLines;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class Address
extends UDDIListObject {
    private String m_useType = null;
    private AddressLines m_addressLines = null;
    private String m_sortCode = null;
    private TModelKey m_tModelKey;

    public Address() {
    }

    public Address(Address address) throws UDDIException {
        if (address == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_useType = address.m_useType;
        this.m_sortCode = address.m_sortCode;
        if (address.m_tModelKey != null) {
            this.m_tModelKey = new TModelKey(address.m_tModelKey);
        }
        if (address.m_addressLines != null) {
            this.m_addressLines = new AddressLines(address.m_addressLines);
        }
    }

    public void setTModelKey(TModelKey tModelKey) {
        this.m_tModelKey = tModelKey;
    }

    public TModelKey getTModelKey() {
        return this.m_tModelKey;
    }

    public void setAddressLines(AddressLines addressLines) throws UDDIException {
        if (this.m_tModelKey != null && addressLines != null) {
            AddressLine addressLine = addressLines.getFirst();
            while (addressLine != null) {
                if (addressLine.getKeyName() == null || addressLine.getKeyValue() == null) {
                    throw new FatalErrorException(UDDIMessages.get("error.fatalError.addressLine"));
                }
                addressLine = addressLines.getNext();
            }
        }
        this.m_addressLines = addressLines;
    }

    public AddressLines getAddressLines() {
        return this.m_addressLines;
    }

    public String getSortCode() {
        return this.m_sortCode;
    }

    public String getUseType() {
        return this.m_useType;
    }

    public void setUseType(String string) {
        this.m_useType = this.truncateString(string, 80);
    }

    public void setSortCode(String string) {
        this.m_sortCode = this.truncateString(string, 10);
    }

    public void addAddressLine(AddressLine addressLine) throws UDDIException {
        if (this.m_addressLines == null) {
            this.m_addressLines = new AddressLines();
        }
        if (this.m_tModelKey != null && (addressLine.getKeyName() == null || addressLine.getKeyValue() == null)) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.addressLine"));
        }
        this.m_addressLines.add(addressLine);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address)) {
            return false;
        }
        Address address = (Address)object;
        boolean bl = true;
        bl &= this.m_addressLines == null ? address.m_addressLines == null : this.m_addressLines.hasEqualContent(address.m_addressLines);
        bl &= Util.isEqual(this.m_sortCode, address.m_sortCode);
        bl &= Util.isEqual(this.m_tModelKey, address.m_tModelKey);
        return bl &= Util.isEqual(this.m_useType, address.m_useType);
    }

    public int hashCode() {
        int n = 0;
        if (this.m_addressLines != null) {
            n ^= this.m_addressLines.hashCode();
        }
        if (this.m_sortCode != null) {
            n ^= this.m_sortCode.hashCode();
        }
        if (this.m_tModelKey != null) {
            n ^= this.m_tModelKey.hashCode();
        }
        if (this.m_useType != null) {
            n ^= this.m_useType.hashCode();
        }
        return n;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("address").append(" ");
        if (this.m_useType != null) {
            stringBuffer.append("useType").append("=\"").append(this.m_useType).append("\" ");
        }
        if (this.m_sortCode != null) {
            stringBuffer.append("sortCode").append("=\"").append(this.m_sortCode).append("\" ");
        }
        if (this.m_tModelKey != null) {
            stringBuffer.append("tModelKey").append("=\"").append(this.m_tModelKey).append("\" ");
        }
        stringBuffer.append(">");
        if (this.m_addressLines != null) {
            stringBuffer.append(this.m_addressLines.toXML());
        }
        stringBuffer.append("</").append("address").append(">");
        return stringBuffer.toString();
    }
}

