/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class AddressLine
extends UDDIListObject {
    private String m_line = null;
    private String m_keyName = null;
    private String m_keyValue = null;

    public AddressLine(String string, String string2, String string3) {
        this.m_line = this.truncateString(string, 80);
        this.m_keyName = this.truncateString(string2, 255);
        this.m_keyValue = this.truncateString(string3, 255);
    }

    public AddressLine(String string) {
        this(string, null, null);
    }

    public AddressLine(AddressLine addressLine) {
        if (addressLine == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_line = addressLine.m_line;
        this.m_keyName = addressLine.m_keyName;
        this.m_keyValue = addressLine.m_keyValue;
    }

    public void setKeyName(String string) {
        this.m_keyName = this.truncateString(string, 255);
    }

    public String getKeyName() {
        return this.m_keyName;
    }

    public void setKeyValue(String string) {
        this.m_keyValue = this.truncateString(string, 255);
    }

    public String getKeyValue() {
        return this.m_keyValue;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AddressLine)) {
            return false;
        }
        AddressLine addressLine = (AddressLine)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_line, addressLine.m_line);
        bl &= Util.isEqual(this.m_keyName, addressLine.m_keyName);
        return bl &= Util.isEqual(this.m_keyValue, addressLine.m_keyValue);
    }

    public int hashCode() {
        int n = 0;
        if (this.m_line != null) {
            n ^= this.m_line.hashCode();
        }
        if (this.m_keyName != null) {
            n ^= this.m_keyName.hashCode();
        }
        if (this.m_keyValue != null) {
            n ^= this.m_keyValue.hashCode();
        }
        return n;
    }

    public String toString() {
        if (this.m_line == null) {
            return "";
        }
        return this.m_line;
    }

    public String getLine() {
        return this.m_line;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("addressLine");
        if (this.m_keyName != null) {
            stringBuffer.append(" ").append("keyName").append("=\"").append(this.m_keyName).append("\"");
        }
        if (this.m_keyValue != null) {
            stringBuffer.append(" ").append("keyValue").append("=\"").append(this.m_keyValue).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.fixStringForXML(this.toString()));
        stringBuffer.append("</").append("addressLine").append(">");
        return stringBuffer.toString();
    }
}

