/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.InvalidCompletionStatusException;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.CompletionStatus;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.PublisherAssertion;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class AssertionStatusItem
extends UDDIListObject {
    private BusinessKey m_fromKey = null;
    private boolean m_fromKeyAsserted;
    private boolean m_fromKeyOwned;
    private BusinessKey m_toKey = null;
    private boolean m_toKeyAsserted;
    private boolean m_toKeyOwned;
    private KeyedReference m_keyedReference = null;
    private CompletionStatus m_completionStatus = null;

    public void setAll(PublisherAssertion publisherAssertion) {
        this.setFromKey(publisherAssertion.getFromKey());
        this.setToKey(publisherAssertion.getToKey());
        this.setKeyedReference(publisherAssertion.getKeyedReference());
        if (publisherAssertion.isFromKeyOwner()) {
            this.setFromKeyAsserted(true);
        } else {
            this.setToKeyAsserted(true);
        }
    }

    public void setFromKey(BusinessKey businessKey) {
        this.m_fromKey = businessKey;
    }

    public BusinessKey getFromKey() {
        return this.m_fromKey;
    }

    public void setToKey(BusinessKey businessKey) {
        this.m_toKey = businessKey;
    }

    public boolean getToKeyOwnership() {
        return this.m_toKeyOwned;
    }

    public boolean isToKeyAsserted() {
        return this.m_toKeyAsserted;
    }

    public void setToKeyAsserted(boolean bl) {
        this.m_toKeyAsserted = bl;
    }

    public void setToKeyOwnership(boolean bl) {
        this.m_toKeyOwned = bl;
    }

    public void setCompletionStatus(String string) throws InvalidCompletionStatusException {
        this.m_completionStatus = new CompletionStatus(string);
    }

    public void setCompletionStatus(CompletionStatus completionStatus) {
        this.m_completionStatus = completionStatus;
    }

    public CompletionStatus getCompletionStatus() {
        return this.m_completionStatus;
    }

    public BusinessKey getToKey() {
        return this.m_toKey;
    }

    public void setFromKeyAsserted(boolean bl) {
        this.m_fromKeyAsserted = bl;
    }

    public boolean isFromKeyAsserted() {
        return this.m_fromKeyAsserted;
    }

    public boolean getFromKeyOwnership() {
        return this.m_fromKeyOwned;
    }

    public void setFromKeyOwnership(boolean bl) {
        this.m_fromKeyOwned = bl;
    }

    public void setKeyedReference(KeyedReference keyedReference) {
        this.m_keyedReference = keyedReference;
    }

    public KeyedReference getKeyedReference() {
        return this.m_keyedReference;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AssertionStatusItem)) {
            return false;
        }
        AssertionStatusItem assertionStatusItem = (AssertionStatusItem)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_fromKey, assertionStatusItem.m_fromKey);
        bl &= Util.isEqual(this.m_toKey, assertionStatusItem.m_toKey);
        bl &= Util.isEqual(this.m_keyedReference, assertionStatusItem.m_keyedReference);
        bl &= this.m_fromKeyOwned == assertionStatusItem.m_fromKeyOwned;
        bl &= this.m_toKeyOwned == assertionStatusItem.m_toKeyOwned;
        return bl &= Util.isEqual(this.m_completionStatus, assertionStatusItem.m_completionStatus);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<assertionStatusItem completionStatus=\"" + this.m_completionStatus + "\">");
        if (this.m_fromKey != null) {
            stringBuffer.append("<fromKey>" + this.m_fromKey.toString() + "</fromKey>");
        }
        if (this.m_toKey != null) {
            stringBuffer.append("<toKey>" + this.m_toKey.toString() + "</toKey>");
        }
        if (this.m_keyedReference != null) {
            stringBuffer.append(this.m_keyedReference.toXML());
        }
        stringBuffer.append("<keysOwned>");
        if (this.m_fromKeyOwned) {
            stringBuffer.append("<fromKey>" + this.m_fromKey.toString() + "</fromKey>");
        }
        if (this.m_toKeyOwned) {
            stringBuffer.append("<toKey>" + this.m_toKey.toString() + "</toKey>");
        }
        stringBuffer.append("</keysOwned>");
        stringBuffer.append("</assertionStatusItem>");
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.toXML();
        return string;
    }
}

