/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIElement;
import weblogic.auddi.util.Util;

public class AuthorizedName
extends UDDIElement
implements Serializable {
    private String m_name = null;

    public AuthorizedName(String string) {
        this.setName(string);
    }

    public AuthorizedName(AuthorizedName authorizedName) {
        if (authorizedName == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_name = authorizedName.m_name;
    }

    public void setName(String string) {
        this.m_name = this.truncateString(string, 255);
    }

    public String getName() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AuthorizedName)) {
            return false;
        }
        AuthorizedName authorizedName = (AuthorizedName)object;
        boolean bl = true;
        return bl &= Util.isEqual(this.m_name, authorizedName.m_name);
    }

    public String toXML() {
        if (this.m_name == null) {
            return "";
        }
        return "<authorizedName>" + this.fixStringForXML(this.m_name) + "</authorizedName>";
    }
}

