/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.util.Date;
import weblogic.auddi.uddi.TooManyOptionsException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.AccessPoint;
import weblogic.auddi.uddi.datastructure.BindingKey;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.HostingRedirector;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModelInstanceDetails;
import weblogic.auddi.uddi.datastructure.TModelInstanceInfo;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class BindingTemplate
extends UDDIListObject
implements Serializable {
    private BindingKey m_bindingKey = null;
    private BusinessKey m_businessKey = null;
    private ServiceKey m_serviceKey = null;
    private Descriptions m_descriptions = null;
    private AccessPoint m_accessPoint = null;
    private HostingRedirector m_hostingRedirector = null;
    private TModelInstanceDetails m_tModelInstanceDetails = new TModelInstanceDetails();

    public BindingTemplate(BindingKey bindingKey) {
        this.m_bindingKey = bindingKey;
    }

    public BindingTemplate(BindingTemplate bindingTemplate) throws UDDIException {
        if (bindingTemplate == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (bindingTemplate.m_bindingKey != null) {
            this.m_bindingKey = new BindingKey(bindingTemplate.m_bindingKey);
        }
        if (bindingTemplate.m_serviceKey != null) {
            this.m_serviceKey = new ServiceKey(bindingTemplate.m_serviceKey);
        }
        if (bindingTemplate.m_businessKey != null) {
            this.m_businessKey = new BusinessKey(bindingTemplate.m_businessKey);
        }
        if (bindingTemplate.m_descriptions != null) {
            this.m_descriptions = new Descriptions(bindingTemplate.m_descriptions);
        }
        if (bindingTemplate.m_accessPoint != null) {
            this.m_accessPoint = new AccessPoint(bindingTemplate.m_accessPoint);
        }
        if (bindingTemplate.m_hostingRedirector != null) {
            this.m_hostingRedirector = new HostingRedirector(bindingTemplate.m_hostingRedirector);
        }
        if (bindingTemplate.m_tModelInstanceDetails != null) {
            this.m_tModelInstanceDetails = bindingTemplate.m_tModelInstanceDetails;
        }
        if (bindingTemplate.m_date != null) {
            this.m_date = new Date(bindingTemplate.m_date.getTime());
        }
    }

    public BindingTemplate() {
    }

    public void setBindingKey(BindingKey bindingKey) {
        this.m_bindingKey = bindingKey;
    }

    public BindingKey getBindingKey() {
        return this.m_bindingKey;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public void setServiceKey(ServiceKey serviceKey) {
        this.m_serviceKey = serviceKey;
    }

    public ServiceKey getServiceKey() {
        return this.m_serviceKey;
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.m_businessKey = businessKey;
    }

    public BusinessKey getBusinessKey() {
        return this.m_businessKey;
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public void setAccessPoint(AccessPoint accessPoint) {
        this.m_accessPoint = accessPoint;
    }

    public AccessPoint getAccessPoint() {
        return this.m_accessPoint;
    }

    public HostingRedirector getHostingRedirector() {
        return this.m_hostingRedirector;
    }

    public void setHostingRedirector(HostingRedirector hostingRedirector) throws UDDIException {
        if (this.m_accessPoint != null) {
            throw new TooManyOptionsException(UDDIMessages.get("error.tooManyOptions.AP_HR"));
        }
        this.m_hostingRedirector = hostingRedirector;
    }

    public void addTModelInstanceInfo(TModelInstanceInfo tModelInstanceInfo) throws UDDIException {
        if (this.m_tModelInstanceDetails == null) {
            this.m_tModelInstanceDetails = new TModelInstanceDetails();
        }
        this.m_tModelInstanceDetails.add(tModelInstanceInfo, tModelInstanceInfo.getTModelKey().toString());
    }

    public void setTModelInstanceDetails(TModelInstanceDetails tModelInstanceDetails) {
        this.m_tModelInstanceDetails = tModelInstanceDetails;
    }

    public TModelInstanceDetails getTModelInstanceDetails() {
        return this.m_tModelInstanceDetails;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BindingTemplate)) {
            return false;
        }
        BindingTemplate bindingTemplate = (BindingTemplate)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_accessPoint, bindingTemplate.m_accessPoint);
        bl &= Util.isEqual(this.m_bindingKey, bindingTemplate.m_bindingKey);
        bl &= this.m_descriptions == null ? bindingTemplate.m_descriptions == null : this.m_descriptions.hasEqualContent(bindingTemplate.m_descriptions);
        bl &= Util.isEqual(this.m_hostingRedirector, bindingTemplate.m_hostingRedirector);
        bl &= Util.isEqual(this.m_serviceKey, bindingTemplate.m_serviceKey);
        return bl &= Util.isEqual(this.m_tModelInstanceDetails, bindingTemplate.m_tModelInstanceDetails);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<bindingTemplate");
        if (this.m_bindingKey != null) {
            stringBuffer.append(" bindingKey=\"").append(this.m_bindingKey.toString()).append("\"");
        } else {
            stringBuffer.append(" bindingKey=\"\"");
        }
        if (this.m_serviceKey != null) {
            stringBuffer.append(" serviceKey=\"").append(this.m_serviceKey.toString()).append("\"");
        }
        stringBuffer.append(">");
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_accessPoint != null) {
            stringBuffer.append(this.m_accessPoint.toXML());
        }
        if (this.m_hostingRedirector != null) {
            stringBuffer.append(this.m_hostingRedirector.toXML());
        }
        if (this.m_tModelInstanceDetails != null) {
            stringBuffer.append(this.m_tModelInstanceDetails.toXML());
        } else {
            stringBuffer.append("<").append("tModelInstanceDetails").append(" />");
        }
        stringBuffer.append("</bindingTemplate>");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bk:").append(this.m_bindingKey);
        stringBuffer.append(", sk:").append(this.m_serviceKey);
        stringBuffer.append(", bk:").append(this.m_businessKey);
        return stringBuffer.toString();
    }
}

