/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.util.Date;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.AuthorizedName;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.BusinessService;
import weblogic.auddi.uddi.datastructure.BusinessServices;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.Contact;
import weblogic.auddi.uddi.datastructure.Contacts;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.DiscoveryURL;
import weblogic.auddi.uddi.datastructure.DiscoveryURLs;
import weblogic.auddi.uddi.datastructure.IdentifierBag;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.datastructure.UniqueNames;
import weblogic.auddi.util.Util;

public class BusinessEntity
extends UDDIListObject
implements Serializable {
    private BusinessKey m_businessKey = null;
    private AuthorizedName m_authorizedName = null;
    private String m_operator = null;
    private DiscoveryURLs m_discoveryURLs = null;
    private UniqueNames m_names = null;
    private Descriptions m_descriptions = null;
    private Contacts m_contacts = null;
    private BusinessServices m_businessServices = null;
    private IdentifierBag m_identifierBag = null;
    private CategoryBag m_categoryBag = null;

    public BusinessEntity(BusinessKey businessKey) {
        this.m_businessKey = businessKey;
    }

    public BusinessEntity() {
    }

    public BusinessEntity(BusinessEntity businessEntity) throws UDDIException {
        if (businessEntity == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (businessEntity.m_businessKey != null) {
            this.m_businessKey = new BusinessKey(businessEntity.m_businessKey);
        }
        if (businessEntity.m_names != null) {
            this.m_names = new UniqueNames(businessEntity.m_names);
        }
        if (businessEntity.m_discoveryURLs != null) {
            this.m_discoveryURLs = new DiscoveryURLs(businessEntity.m_discoveryURLs);
        }
        if (businessEntity.m_descriptions != null) {
            this.m_descriptions = new Descriptions(businessEntity.m_descriptions);
        }
        if (businessEntity.m_authorizedName != null) {
            this.m_authorizedName = new AuthorizedName(businessEntity.m_authorizedName);
        }
        if (businessEntity.m_contacts != null) {
            this.m_contacts = new Contacts(businessEntity.m_contacts);
        }
        if (businessEntity.m_date != null) {
            this.m_date = new Date(businessEntity.m_date.getTime());
        }
        if (businessEntity.m_categoryBag != null) {
            this.m_categoryBag = new CategoryBag(businessEntity.m_categoryBag);
        }
        if (businessEntity.m_identifierBag != null) {
            this.m_identifierBag = new IdentifierBag(businessEntity.m_identifierBag);
        }
        this.m_operator = businessEntity.m_operator;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public void setNames(UniqueNames uniqueNames) {
        this.m_names = uniqueNames;
    }

    public void setAuthorizedName(String string) {
        if (this.m_authorizedName == null) {
            this.m_authorizedName = new AuthorizedName(string);
        } else {
            this.m_authorizedName.setName(string);
        }
    }

    public void setAuthorizedName(AuthorizedName authorizedName) {
        this.m_authorizedName = authorizedName;
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.m_businessKey = businessKey;
    }

    public BusinessKey getBusinessKey() {
        return this.m_businessKey;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public Contacts getContacts() {
        return this.m_contacts;
    }

    public void setOperator(String string) {
        this.m_operator = string;
    }

    public void setDiscoveryURLs(DiscoveryURLs discoveryURLs) {
        this.m_discoveryURLs = discoveryURLs;
    }

    public DiscoveryURLs getDiscoveryURLs() {
        return this.m_discoveryURLs;
    }

    public void addDiscoveryURL(DiscoveryURL discoveryURL) throws UDDIException {
        if (this.m_discoveryURLs == null) {
            this.m_discoveryURLs = new DiscoveryURLs();
        }
        this.m_discoveryURLs.add(discoveryURL);
    }

    public void addName(Name name) throws UDDIException {
        if (this.m_names == null) {
            this.m_names = new UniqueNames();
        }
        this.m_names.add(name);
    }

    public UniqueNames getNames() {
        return this.m_names;
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void setContacts(Contacts contacts) {
        this.m_contacts = contacts;
    }

    public void addContact(Contact contact) throws UDDIException {
        if (this.m_contacts == null) {
            this.m_contacts = new Contacts();
        }
        this.m_contacts.add(contact);
    }

    public void setBusinessServices(BusinessServices businessServices) {
        this.m_businessServices = businessServices;
    }

    public void addBusinessService(BusinessService businessService) throws UDDIException {
        if (this.m_businessServices == null) {
            this.m_businessServices = new BusinessServices();
        }
        this.m_businessServices.add(businessService);
    }

    public BusinessServices getBusinessServices() {
        return this.m_businessServices;
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        this.m_identifierBag = identifierBag;
    }

    public void addIdentifier(KeyedReference keyedReference) throws UDDIException {
        if (this.m_identifierBag == null) {
            this.m_identifierBag = new IdentifierBag();
        }
        this.m_identifierBag.add(keyedReference);
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.m_categoryBag = categoryBag;
    }

    public CategoryBag getCategoryBag() {
        return this.m_categoryBag;
    }

    public IdentifierBag getIdentifierBag() {
        return this.m_identifierBag;
    }

    public AuthorizedName getAuthorizedName() {
        return this.m_authorizedName;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public void addCategory(KeyedReference keyedReference) throws UDDIException {
        if (this.m_categoryBag == null) {
            this.m_categoryBag = new CategoryBag();
        }
        this.m_categoryBag.add(keyedReference);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BusinessEntity)) {
            return false;
        }
        BusinessEntity businessEntity = (BusinessEntity)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_businessKey, businessEntity.m_businessKey);
        bl &= this.m_businessServices == null || this.m_businessServices.size() == 0 ? businessEntity.m_businessServices == null || businessEntity.m_businessServices.size() == 0 : this.m_businessServices.hasEqualContent(businessEntity.m_businessServices);
        bl &= Util.isEqual(this.m_categoryBag, businessEntity.m_categoryBag);
        bl &= this.m_contacts == null ? businessEntity.m_contacts == null : this.m_contacts.hasEqualContent(businessEntity.m_contacts);
        bl &= this.m_descriptions == null ? businessEntity.m_descriptions == null : this.m_descriptions.hasEqualContent(businessEntity.m_descriptions);
        bl &= this.m_discoveryURLs == null ? businessEntity.m_discoveryURLs == null : this.m_discoveryURLs.hasEqualContent(businessEntity.m_discoveryURLs);
        bl &= Util.isEqual(this.m_identifierBag, businessEntity.m_identifierBag);
        bl &= this.m_names == null ? businessEntity.m_names == null : this.m_names.hasEqualContent(businessEntity.m_names);
        bl &= Util.isEqual(this.m_authorizedName, businessEntity.m_authorizedName);
        return bl &= Util.isEqual(this.m_operator, businessEntity.getOperator());
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<businessEntity");
        if (this.m_businessKey != null) {
            stringBuffer.append(" businessKey=\"").append(this.m_businessKey.toString()).append("\"");
        } else {
            stringBuffer.append(" businessKey=\"\"");
        }
        if (this.m_authorizedName != null) {
            stringBuffer.append(" authorizedName=\"").append(this.m_authorizedName.toString()).append("\"");
        }
        if (this.m_operator != null) {
            stringBuffer.append(" operator=\"").append(this.m_operator).append("\"");
        }
        stringBuffer.append(">");
        if (this.m_discoveryURLs != null) {
            stringBuffer.append(this.m_discoveryURLs.toXML());
        }
        if (this.m_names != null) {
            stringBuffer.append(this.m_names.toXML(""));
        }
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_contacts != null) {
            stringBuffer.append(this.m_contacts.toXML());
        }
        if (this.m_businessServices != null) {
            stringBuffer.append(this.m_businessServices.toXML());
        }
        if (this.m_identifierBag != null) {
            stringBuffer.append(this.m_identifierBag.toXML());
        }
        if (this.m_categoryBag != null) {
            stringBuffer.append(this.m_categoryBag.toXML());
        }
        stringBuffer.append("</businessEntity>");
        return stringBuffer.toString();
    }
}

