/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.util.Date;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.BindingTemplate;
import weblogic.auddi.uddi.datastructure.BindingTemplates;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.datastructure.UniqueNames;
import weblogic.auddi.util.Util;

public class BusinessService
extends UDDIListObject
implements Serializable {
    private BusinessKey m_businessKey = null;
    private ServiceKey m_serviceKey = null;
    private UniqueNames m_names = null;
    private Descriptions m_descriptions = null;
    private BindingTemplates m_bindingTemplates = new BindingTemplates();
    private CategoryBag m_categories = null;
    private boolean m_isProjection = false;

    public BusinessService() {
    }

    public BusinessService(BusinessService businessService) throws UDDIException {
        this();
        if (businessService == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (businessService.m_businessKey != null) {
            this.m_businessKey = new BusinessKey(businessService.m_businessKey);
        }
        if (businessService.m_serviceKey != null) {
            this.m_serviceKey = new ServiceKey(businessService.m_serviceKey);
        }
        if (businessService.m_names != null) {
            this.m_names = new UniqueNames(businessService.m_names);
        }
        if (businessService.m_descriptions != null) {
            this.m_descriptions = new Descriptions(businessService.m_descriptions);
        }
        if (businessService.m_categories != null) {
            this.m_categories = new CategoryBag(businessService.m_categories);
        }
        if (businessService.m_date != null) {
            this.m_date = new Date(businessService.m_date.getTime());
        }
        if (businessService.m_bindingTemplates != null) {
            this.m_bindingTemplates = new BindingTemplates(businessService.m_bindingTemplates);
        }
        this.m_isProjection = businessService.m_isProjection;
    }

    public boolean isProjection() {
        return this.m_isProjection;
    }

    public void setIsProjection(boolean bl) {
        this.m_isProjection = bl;
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.m_businessKey = businessKey;
    }

    public BusinessKey getBusinessKey() {
        return this.m_businessKey;
    }

    public void setServiceKey(ServiceKey serviceKey) {
        this.m_serviceKey = serviceKey;
    }

    public ServiceKey getServiceKey() {
        return this.m_serviceKey;
    }

    public void addName(Name name) throws UDDIException {
        if (this.m_names == null) {
            this.m_names = new UniqueNames();
        }
        this.m_names.add(name);
    }

    public UniqueNames getNames() {
        return this.m_names;
    }

    public void setNames(UniqueNames uniqueNames) {
        this.m_names = uniqueNames;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public CategoryBag getCategoryBag() {
        return this.m_categories;
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void addBindingTemplate(BindingTemplate bindingTemplate) throws UDDIException {
        this.m_bindingTemplates.add(bindingTemplate);
    }

    public void setBindingTemplates(BindingTemplates bindingTemplates) {
        this.m_bindingTemplates = bindingTemplates;
    }

    public BindingTemplates getBindingTemplates() {
        return this.m_bindingTemplates;
    }

    public void addCategory(KeyedReference keyedReference) throws UDDIException {
        if (this.m_categories == null) {
            this.m_categories = new CategoryBag();
        }
        this.m_categories.add(keyedReference);
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.m_categories = categoryBag;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BusinessService)) {
            return false;
        }
        BusinessService businessService = (BusinessService)object;
        boolean bl = true;
        bl &= this.m_bindingTemplates == null ? businessService.m_bindingTemplates == null : this.m_bindingTemplates.hasEqualContent(businessService.m_bindingTemplates);
        bl &= Util.isEqual(this.m_businessKey, businessService.m_businessKey);
        bl &= Util.isEqual(this.m_categories, businessService.m_categories);
        bl &= this.m_descriptions == null ? businessService.m_descriptions == null : this.m_descriptions.hasEqualContent(businessService.m_descriptions);
        bl &= this.m_names == null ? businessService.m_names == null : this.m_names.hasEqualContent(businessService.m_names);
        return bl &= Util.isEqual(this.m_serviceKey, businessService.m_serviceKey);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<businessService");
        if (this.m_serviceKey != null) {
            stringBuffer.append(" serviceKey=\"").append(this.m_serviceKey.toString()).append("\"");
        } else {
            stringBuffer.append(" serviceKey=\"\"");
        }
        if (this.m_businessKey != null) {
            stringBuffer.append(" businessKey=\"").append(this.m_businessKey.toString()).append("\"");
        }
        stringBuffer.append(">");
        if (this.m_names != null) {
            stringBuffer.append(this.m_names.toXML());
        }
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_bindingTemplates != null) {
            stringBuffer.append(this.m_bindingTemplates.toXML());
        } else {
            stringBuffer.append("<").append("bindingTemplates").append(" />");
        }
        if (this.m_categories != null) {
            stringBuffer.append(this.m_categories.toXML());
        }
        stringBuffer.append("</businessService>");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sk:").append(this.m_serviceKey);
        stringBuffer.append(", bk:").append(this.m_businessKey);
        if (this.m_bindingTemplates != null) {
            stringBuffer.append("\n     bt size:").append(this.m_bindingTemplates.size());
            for (int i = 0; i < this.m_bindingTemplates.size(); ++i) {
                BindingTemplate bindingTemplate = (BindingTemplate)this.m_bindingTemplates.get(i);
                stringBuffer.append("\n     ").append(bindingTemplate.toString());
            }
        } else {
            stringBuffer.append("\n     bt: null");
        }
        return stringBuffer.toString();
    }
}

