/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.InvalidCompletionStatusException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;

public class CompletionStatus
extends UDDIListObject
implements Serializable {
    public static final String STATUS_COMPLETE = "status:complete";
    public static final String STATUS_TO_KEY_INCOMPLETE = "status:toKey_incomplete";
    public static final String STATUS_FROM_KEY_INCOMPLETE = "status:fromKey_incomplete";
    private String m_text = null;

    public CompletionStatus(String string) throws InvalidCompletionStatusException {
        if (!(string.equals(STATUS_COMPLETE) || string.equals(STATUS_TO_KEY_INCOMPLETE) || string.equals(STATUS_FROM_KEY_INCOMPLETE))) {
            throw new InvalidCompletionStatusException(UDDIMessages.get("error.invalidCompletionStatus.status", string));
        }
        this.m_text = string;
    }

    public CompletionStatus(CompletionStatus completionStatus) {
        if (completionStatus == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_text = completionStatus.m_text;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompletionStatus)) {
            return false;
        }
        CompletionStatus completionStatus = (CompletionStatus)object;
        boolean bl = true;
        if (!(bl &= Util.isEqual(this.m_text, completionStatus.m_text))) {
            Logger.debug("CompletionStatus not equal:::" + this.m_text + "!=" + completionStatus.m_text);
        }
        return bl;
    }

    public String getCompletionStatus() {
        return this.m_text;
    }

    public String toString() {
        if (this.m_text == null) {
            return "";
        }
        return this.m_text;
    }

    public String toXML() {
        if (this.m_text == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("completionStatus");
        stringBuffer.append(">").append(this.fixStringForXML(this.m_text)).append("</").append("completionStatus").append(">");
        return stringBuffer.toString();
    }
}

