/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Address;
import weblogic.auddi.uddi.datastructure.Addresses;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.Email;
import weblogic.auddi.uddi.datastructure.Emails;
import weblogic.auddi.uddi.datastructure.Phone;
import weblogic.auddi.uddi.datastructure.Phones;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class Contact
extends UDDIListObject {
    private String m_useType = null;
    private Descriptions m_descriptions = null;
    private String m_personName = null;
    private Phones m_phones = null;
    private Emails m_emails = null;
    private Addresses m_addresses = null;

    public Contact() {
    }

    public Contact(Contact contact) throws UDDIException {
        if (contact == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_useType = contact.m_useType;
        this.m_personName = contact.m_personName;
        if (contact.m_descriptions != null) {
            this.m_descriptions = new Descriptions(contact.m_descriptions);
        }
        if (contact.m_phones != null) {
            this.m_phones = new Phones(contact.m_phones);
        }
        if (contact.m_emails != null) {
            this.m_emails = new Emails(contact.m_emails);
        }
        if (contact.m_addresses != null) {
            this.m_addresses = new Addresses(contact.m_addresses);
        }
    }

    public Contact(String string) {
        this.setPersonName(string);
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public String getPersonName() {
        return this.m_personName;
    }

    public void setPersonName(String string) {
        this.m_personName = this.truncateString(string, 255);
    }

    public void setAddresses(Addresses addresses) {
        this.m_addresses = addresses;
    }

    public Addresses getAddresses() {
        return this.m_addresses;
    }

    public String getUseType() {
        return this.m_useType;
    }

    public void setUseType(String string) {
        this.m_useType = this.truncateString(string, 255);
    }

    public void setEmails(Emails emails) {
        this.m_emails = emails;
    }

    public Emails getEmails() {
        return this.m_emails;
    }

    public void setPhones(Phones phones) {
        this.m_phones = phones;
    }

    public Phones getPhones() {
        return this.m_phones;
    }

    public void addAddress(Address address) throws UDDIException {
        if (this.m_addresses == null) {
            this.m_addresses = new Addresses();
        }
        this.m_addresses.add(address);
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void addPhone(Phone phone) throws UDDIException {
        if (this.m_phones == null) {
            this.m_phones = new Phones();
        }
        this.m_phones.add(phone);
    }

    public void addEmail(Email email) throws UDDIException {
        if (this.m_emails == null) {
            this.m_emails = new Emails();
        }
        this.m_emails.add(email);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Contact)) {
            return false;
        }
        Contact contact = (Contact)object;
        boolean bl = true;
        bl &= this.m_addresses == null ? contact.m_addresses == null : this.m_addresses.hasEqualContent(contact.m_addresses);
        bl &= this.m_descriptions == null ? contact.m_descriptions == null : this.m_descriptions.hasEqualContent(contact.m_descriptions);
        bl &= this.m_emails == null ? contact.m_emails == null : this.m_emails.hasEqualContent(contact.m_emails);
        bl &= Util.isEqual(this.m_personName, contact.m_personName);
        bl &= this.m_phones == null ? contact.m_phones == null : this.m_phones.hasEqualContent(contact.m_phones);
        return bl &= Util.isEqual(this.m_useType, contact.m_useType);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_useType != null) {
            stringBuffer.append("   useType : " + this.m_useType + "\n");
        }
        if (this.m_personName != null) {
            stringBuffer.append(" personName : " + this.m_personName + "\n");
        }
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toString());
        }
        if (this.m_addresses != null) {
            stringBuffer.append(this.m_addresses.toString());
        }
        if (this.m_phones != null) {
            stringBuffer.append(this.m_phones.toString());
        }
        if (this.m_emails != null) {
            stringBuffer.append(this.m_emails.toString());
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<contact");
        if (this.m_useType != null) {
            stringBuffer.append(" useType=\"").append(this.m_useType).append("\" ");
        }
        stringBuffer.append(">");
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_personName != null) {
            stringBuffer.append("<personName>").append(this.fixStringForXML(this.m_personName)).append("</personName>");
        }
        if (this.m_phones != null) {
            stringBuffer.append(this.m_phones.toXML());
        }
        if (this.m_emails != null) {
            stringBuffer.append(this.m_emails.toXML());
        }
        if (this.m_addresses != null) {
            stringBuffer.append(this.m_addresses.toXML());
        }
        stringBuffer.append("</contact>");
        return stringBuffer.toString();
    }
}

