/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Language;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;

public class Description
extends UDDIListObject
implements Serializable {
    Language m_lang = null;
    String m_text = null;

    public Description(String string, Language language) {
        this.m_text = this.truncateString(string, 255);
        this.m_lang = language;
    }

    public Description(String string) throws UDDIException {
        this(string, new Language());
    }

    public Description(Description description) throws UDDIException {
        if (description == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (description.m_lang != null) {
            this.m_lang = new Language(description.m_lang);
        }
        this.m_text = description.m_text;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Description)) {
            return false;
        }
        Description description = (Description)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_lang, description.m_lang);
        if (!(bl &= Util.isEqual(this.m_text, description.m_text))) {
            Logger.debug("Description not equal:::" + this.m_text + "!=" + description.m_text);
        }
        return bl;
    }

    public Language getLang() {
        return this.m_lang;
    }

    public void setLang(Language language) {
        this.m_lang = language;
    }

    public String getText() {
        return this.m_text;
    }

    public String toString() {
        return this.m_text;
    }

    public String toXML() {
        if (this.m_text == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("description");
        if (this.m_lang != null) {
            stringBuffer.append(" ").append("xml:lang").append("=\"").append(this.m_lang.toString()).append("\"");
        }
        stringBuffer.append(">").append(this.fixStringForXML(this.m_text)).append("</").append("description").append(">");
        return stringBuffer.toString();
    }
}

