/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.util.HashMap;
import weblogic.auddi.uddi.LanguageErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.UDDIList;
import weblogic.auddi.util.Util;

public class Descriptions
extends UDDIList
implements Serializable {
    HashMap m_map = null;

    public Descriptions() {
    }

    public Descriptions(Descriptions descriptions) throws UDDIException {
        if (descriptions == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        Description description = descriptions.getFirst();
        while (description != null) {
            this.add(new Description(description));
            description = descriptions.getNext();
        }
    }

    public void remove(Description description) throws UDDIException {
        super.remove(description);
        String string = description.getLang().toString();
        this.m_map.remove(string);
    }

    public void add(Description description) throws UDDIException {
        String string;
        if (this.m_map == null) {
            this.m_map = new HashMap();
        }
        if (this.m_map.get(string = description.getLang().toString()) != null) {
            throw new LanguageErrorException(UDDIMessages.get("error.languageError.description", string));
        }
        super.add(description);
        this.m_map.put(string, description);
    }

    public Description getFirst() {
        return (Description)super.getVFirst();
    }

    public Description getNext() {
        return (Description)super.getVNext();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Descriptions)) {
            return false;
        }
        Descriptions descriptions = (Descriptions)object;
        boolean bl = true;
        return bl &= Util.isEqual(this.m_map, descriptions.m_map);
    }

    public String toXML() {
        return super.toXML("");
    }
}

