/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.net.URL;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.UnsupportedException;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class DiscoveryURL
extends UDDIListObject
implements Serializable {
    public static final String BUSINESS_ENTITY = "businessEntity";
    public static final String BUSINESS_ENTITY_EXT = "businessEntityExt";
    private static final long serialVersionUID = 3117297632480683256L;
    private String m_useType = null;
    private String m_url = null;

    public DiscoveryURL() {
    }

    public DiscoveryURL(DiscoveryURL discoveryURL) throws UDDIException {
        if (discoveryURL == null) {
            throw new IllegalArgumentException("parameter to copy constructor was null");
        }
        this.m_url = discoveryURL.m_url;
        this.m_useType = discoveryURL.m_useType;
    }

    public DiscoveryURL(String string, String string2) throws UDDIException {
        this.setUseType(string);
        this.setUrl(string2);
    }

    public void setUseType(String string) throws UDDIException {
        if (string == null) {
            throw new UnsupportedException(UDDIMessages.get("error.unsupported.type", "useType", string));
        }
        this.m_useType = this.truncateString(string, 255);
    }

    public void setUrl(URL uRL) throws UDDIException {
        if (uRL == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "discoveryURL"));
        }
        this.setUrl(uRL.toString());
    }

    public void setUrl(String string) throws UDDIException {
        if (string == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "discoveryURL"));
        }
        this.m_url = this.truncateString(string, 255);
    }

    public String getUrl() {
        if (this.m_url == null) {
            return "";
        }
        return this.m_url.toString();
    }

    public String getUseType() {
        return this.m_useType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiscoveryURL)) {
            return false;
        }
        DiscoveryURL discoveryURL = (DiscoveryURL)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_url, discoveryURL.m_url);
        return bl &= Util.isEqual(this.m_useType, discoveryURL.m_useType);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<discoveryURL");
        if (this.m_useType != null) {
            stringBuffer.append(" useType=\"" + this.m_useType + "\">");
        }
        stringBuffer.append(this.getUrl());
        stringBuffer.append("</discoveryURL>");
        return stringBuffer.toString();
    }
}

