/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class Email
extends UDDIListObject {
    private String m_email = null;
    private String m_useType;

    public Email(String string) {
        this(string, null);
    }

    public Email(String string, String string2) {
        if (string == null) {
            return;
        }
        this.m_email = this.truncateString(string, 255);
        this.m_useType = this.truncateString(string2, 255);
    }

    public Email(Email email) {
        if (email == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_email = email.m_email;
        this.m_useType = email.m_useType;
    }

    public String getUseType() {
        return this.m_useType;
    }

    public void setUseType(String string) {
        this.m_useType = this.truncateString(string, 255);
    }

    public String getEmail() {
        return this.m_email;
    }

    public String toString() {
        return this.m_email;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Email)) {
            return false;
        }
        Email email = (Email)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_email, email.m_email);
        return bl &= Util.isEqual(this.m_useType, email.m_useType);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<email");
        if (this.m_useType != null) {
            stringBuffer.append(" useType=\"").append(this.m_useType).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.m_email);
        stringBuffer.append("</email>");
        return stringBuffer.toString();
    }
}

