/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.InstanceParms;
import weblogic.auddi.uddi.datastructure.OverviewDoc;
import weblogic.auddi.uddi.datastructure.UDDIElement;
import weblogic.auddi.util.Util;

public class InstanceDetails
extends UDDIElement {
    private Descriptions m_descriptions = null;
    private OverviewDoc m_overviewDoc = null;
    private InstanceParms m_instanceParms = null;

    public InstanceDetails() {
    }

    public InstanceDetails(InstanceDetails instanceDetails) throws UDDIException {
        if (instanceDetails == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (instanceDetails.m_descriptions != null) {
            this.m_descriptions = new Descriptions(instanceDetails.m_descriptions);
        }
        if (instanceDetails.m_overviewDoc != null) {
            this.m_overviewDoc = new OverviewDoc(instanceDetails.m_overviewDoc);
        }
        if (instanceDetails.m_instanceParms != null) {
            this.m_instanceParms = new InstanceParms(instanceDetails.m_instanceParms);
        }
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public OverviewDoc getOverviewDoc() {
        return this.m_overviewDoc;
    }

    public InstanceParms getInstanceParms() {
        return this.m_instanceParms;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public void setOverviewDoc(OverviewDoc overviewDoc) {
        this.m_overviewDoc = overviewDoc;
    }

    public void setInstanceParms(InstanceParms instanceParms) {
        this.m_instanceParms = instanceParms;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InstanceDetails)) {
            return false;
        }
        InstanceDetails instanceDetails = (InstanceDetails)object;
        boolean bl = true;
        bl &= this.m_descriptions == null ? instanceDetails.m_descriptions == null : this.m_descriptions.hasEqualContent(instanceDetails.m_descriptions);
        bl &= Util.isEqual(this.m_instanceParms, instanceDetails.m_instanceParms);
        return bl &= Util.isEqual(this.m_overviewDoc, instanceDetails.m_overviewDoc);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<instanceDetails>");
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_overviewDoc != null) {
            stringBuffer.append(this.m_overviewDoc.toXML());
        }
        if (this.m_instanceParms != null) {
            stringBuffer.append(this.m_instanceParms.toXML());
        }
        stringBuffer.append("</instanceDetails>");
        return stringBuffer.toString();
    }
}

