/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.UDDIBagObject;
import weblogic.auddi.util.Util;

public class KeyedReference
extends UDDIBagObject
implements Serializable {
    private TModelKey m_tModelKey;
    private String m_keyName;
    private String m_keyValue;
    private boolean m_standard = false;

    public KeyedReference(TModelKey tModelKey, String string, String string2) throws FatalErrorException {
        if (string2 == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "keyValue"));
        }
        this.m_tModelKey = tModelKey;
        this.m_keyName = this.truncateString(string, 255);
        this.m_keyValue = this.truncateString(string2, 255);
    }

    public KeyedReference(KeyedReference keyedReference) throws UDDIException {
        if (keyedReference == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (keyedReference.m_tModelKey != null) {
            this.m_tModelKey = new TModelKey(keyedReference.m_tModelKey);
        }
        this.m_keyName = keyedReference.m_keyName;
        this.m_keyValue = keyedReference.m_keyValue;
        this.m_standard = keyedReference.m_standard;
    }

    public String getKey() {
        String string = "";
        if (this.m_tModelKey != null) {
            string = string + this.m_tModelKey.toString();
        }
        if (this.m_keyValue != null) {
            string = string + this.m_keyValue;
        }
        return string;
    }

    public String getName() {
        return this.m_keyName;
    }

    public String getValue() {
        return this.m_keyValue;
    }

    public TModelKey getTModelKey() {
        return this.m_tModelKey;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyedReference)) {
            return false;
        }
        KeyedReference keyedReference = (KeyedReference)object;
        boolean bl = true;
        bl &= Util.isEqual(this.getName(), keyedReference.getName());
        bl &= Util.isEqual(this.getValue(), keyedReference.getValue());
        return bl &= Util.isEqual(this.getTModelKey(), keyedReference.getTModelKey());
    }

    public int hashCode() {
        int n = 17;
        if (this.m_tModelKey != null) {
            n = 37 * n + this.m_tModelKey.hashCode();
        }
        if (this.m_keyName != null) {
            n = 37 * n + this.m_keyName.hashCode();
        }
        if (this.m_keyValue != null) {
            n = 37 * n + this.m_keyValue.hashCode();
        }
        return n;
    }

    public boolean isStandard() {
        return this.m_standard;
    }

    public void setStandard(boolean bl) {
        this.m_standard = bl;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<keyedReference");
        if (this.m_tModelKey != null) {
            stringBuffer.append(" tModelKey=\"").append(this.m_tModelKey.toString()).append("\"");
        }
        if (this.m_keyName != null) {
            stringBuffer.append(" keyName=\"").append(this.fixStringForXML(this.m_keyName)).append("\"");
        }
        if (this.m_keyValue != null) {
            stringBuffer.append(" keyValue=\"").append(this.fixStringForXML(this.m_keyValue)).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append("</keyedReference>");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tModelKey : " + this.m_tModelKey + ", ");
        stringBuffer.append("  keyName : " + this.m_keyName + ", ");
        stringBuffer.append(" keyValue : " + this.m_keyValue);
        return stringBuffer.toString();
    }
}

