/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIElement;
import weblogic.auddi.uddi.util.StandardLanguages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.util.Util;

public class Language
extends UDDIElement {
    public static final String DEFAULT_LANG = PropertyManager.getRuntimeProperty("auddi.default.lang");
    private String m_lang = null;
    private String m_name = null;
    private String m_family = null;

    public Language() throws UDDIException {
        this(DEFAULT_LANG == null ? "en" : DEFAULT_LANG);
    }

    public Language(String string) throws UDDIException {
        if (string != null) {
            Language language = StandardLanguages.getInstance().getByCode(string);
            if (language == null) {
                throw new IllegalArgumentException(UDDIMessages.get("error.runtime.language.invalid"));
            }
            this.m_lang = language.m_lang;
            this.m_name = language.m_name;
            this.m_family = language.m_family;
        }
    }

    public Language(String string, String string2, String string3) {
        this.m_lang = string;
        this.m_name = string2;
        this.m_family = string3;
    }

    public Language(Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Parameter to copy constructor was null");
        }
        this.m_lang = language.m_lang;
        this.m_name = language.m_name;
        this.m_family = language.m_family;
    }

    public String getFamily() {
        return this.m_family;
    }

    public String getName() {
        return this.m_name;
    }

    public String getText() {
        return this.getLang();
    }

    public String getLang() {
        if (this.m_lang == null) {
            return "";
        }
        return this.m_lang;
    }

    public String toString() {
        if (this.m_lang == null) {
            return "";
        }
        return this.m_lang;
    }

    public String toXML() {
        if (this.m_lang == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ").append("xml:lang").append("=\"").append(this.m_lang).append("\"");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Language)) {
            return false;
        }
        Language language = (Language)object;
        boolean bl = true;
        if (!(bl &= Util.isEqual(this.m_lang, language.m_lang))) {
            Logger.debug("Language not equal:::" + this.m_lang + "!=" + language.m_lang);
        }
        return bl;
    }
}

