/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.Language;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class Name
extends UDDIListObject
implements Serializable {
    private String m_name = null;
    private Language m_lang = null;

    public Name(String string) throws UDDIException {
        this(string, null);
    }

    public Name(Name name) {
        this.m_name = name.m_name;
        this.m_lang = name.m_lang;
    }

    public Name(String string, Language language) {
        this.setName(string);
        this.m_lang = language;
    }

    public void setName(String string) {
        this.m_name = this.truncateString(string, 255);
    }

    public void setName(String string, Language language) {
        this.setName(string);
        this.m_lang = language;
    }

    public String getName() {
        return this.m_name;
    }

    public Language getLang() {
        return this.m_lang;
    }

    public void setLang(Language language) {
        this.m_lang = language;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_name, name.m_name);
        return bl &= Util.isEqual(this.m_lang, name.m_lang);
    }

    public String toString() {
        return this.m_name;
    }

    public String toXML() {
        if (this.m_name == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("name");
        if (this.m_lang != null) {
            stringBuffer.append(this.m_lang.toXML());
        }
        stringBuffer.append(">").append(this.fixStringForXML(this.m_name)).append("</").append("name").append(">");
        return stringBuffer.toString();
    }
}

