/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.net.MalformedURLException;
import java.net.URL;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.UDDIElement;
import weblogic.auddi.util.Util;

public class OverviewDoc
extends UDDIElement {
    private Descriptions m_descriptions = null;
    private URL m_overviewURL = null;

    public OverviewDoc() {
    }

    public OverviewDoc(OverviewDoc overviewDoc) throws UDDIException {
        if (overviewDoc == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (overviewDoc.m_descriptions != null) {
            this.m_descriptions = new Descriptions(overviewDoc.m_descriptions);
        }
        if (overviewDoc.m_overviewURL != null) {
            this.setOverviewURL(overviewDoc.m_overviewURL.toString());
        }
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void setOverviewURL(URL uRL) {
        this.m_overviewURL = uRL;
    }

    public void setOverviewURL(String string) throws FatalErrorException {
        try {
            string = this.truncateString(string, 255);
            this.m_overviewURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.malformedURL", string), malformedURLException);
        }
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public URL getOverviewURL() {
        return this.m_overviewURL;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OverviewDoc)) {
            return false;
        }
        OverviewDoc overviewDoc = (OverviewDoc)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_descriptions, overviewDoc.m_descriptions);
        return bl &= Util.isEqual(this.m_overviewURL, overviewDoc.m_overviewURL);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<overviewDoc>");
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_overviewURL != null) {
            stringBuffer.append("<overviewURL>").append(this.m_overviewURL.toString()).append("</overviewURL>");
        }
        stringBuffer.append("</overviewDoc>");
        return stringBuffer.toString();
    }
}

