/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class Phone
extends UDDIListObject {
    private String m_phoneNumber;
    private String m_useType = null;

    public Phone(String string) {
        this(string, null);
    }

    public Phone(String string, String string2) {
        if (string == null) {
            return;
        }
        this.m_phoneNumber = this.truncateString(string, 50);
        this.m_useType = this.truncateString(string2, 255);
    }

    public Phone(Phone phone) {
        if (phone == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        this.m_phoneNumber = phone.m_phoneNumber;
        this.m_useType = phone.m_useType;
    }

    public void setUseType(String string) {
        this.m_useType = string;
    }

    public String getUseType() {
        return this.m_useType;
    }

    public String getPhoneNumber() {
        return this.m_phoneNumber;
    }

    public String toString() {
        return this.m_phoneNumber;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Phone)) {
            return false;
        }
        Phone phone = (Phone)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_phoneNumber, phone.m_phoneNumber);
        return bl &= Util.isEqual(this.m_useType, phone.m_useType);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<phone");
        if (this.m_useType != null) {
            stringBuffer.append(" useType=\"").append(this.m_useType).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.m_phoneNumber);
        stringBuffer.append("</phone>");
        return stringBuffer.toString();
    }
}

