/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.AuthorizedName;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.IdentifierBag;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.Operator;
import weblogic.auddi.uddi.datastructure.OverviewDoc;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.util.Util;

public class TModel
extends UDDIListObject {
    private TModelKey m_tModelKey = null;
    private AuthorizedName m_authorizedName = null;
    private Operator m_operator = null;
    private Name m_name = null;
    private Descriptions m_descriptions;
    private OverviewDoc m_overviewDoc = null;
    private IdentifierBag m_identifierBag = null;
    private CategoryBag m_categoryBag = null;
    protected boolean m_isHidden = false;

    public TModel() {
    }

    public TModel(TModelKey tModelKey) {
        this.m_tModelKey = tModelKey;
    }

    public TModel(TModelKey tModelKey, String string) throws UDDIException {
        this.m_tModelKey = tModelKey;
        this.m_name = new Name(string);
    }

    public TModel(TModel tModel) throws UDDIException {
        if (tModel == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (tModel.m_authorizedName != null) {
            this.m_authorizedName = new AuthorizedName(tModel.m_authorizedName);
        }
        if (tModel.m_tModelKey != null) {
            this.m_tModelKey = new TModelKey(tModel.m_tModelKey);
        }
        if (tModel.m_name != null) {
            this.m_name = new Name(tModel.m_name);
        }
        if (tModel.m_operator != null) {
            this.m_operator = new Operator(tModel.m_operator.getName());
        }
        if (tModel.m_descriptions != null) {
            this.m_descriptions = new Descriptions(tModel.m_descriptions);
        }
        if (tModel.m_categoryBag != null) {
            this.m_categoryBag = new CategoryBag(tModel.m_categoryBag);
        }
        if (tModel.m_identifierBag != null) {
            this.m_identifierBag = new IdentifierBag(tModel.m_identifierBag);
        }
        if (tModel.m_overviewDoc != null) {
            this.m_overviewDoc = new OverviewDoc(tModel.m_overviewDoc);
        }
        this.m_isHidden = tModel.m_isHidden;
    }

    public void setAuthorizedName(String string) {
        if (this.m_authorizedName == null) {
            this.m_authorizedName = new AuthorizedName(string);
        } else {
            this.m_authorizedName.setName(string);
        }
    }

    public void setAuthorizedName(AuthorizedName authorizedName) {
        this.m_authorizedName = authorizedName;
    }

    public void setTModelKey(TModelKey tModelKey) {
        this.m_tModelKey = tModelKey;
    }

    public TModelKey getTModelKey() {
        return this.m_tModelKey;
    }

    public void setName(Name name) {
        if (name != null) {
            name.setLang(null);
        }
        this.m_name = name;
    }

    public Name getName() {
        return this.m_name;
    }

    public void setOverviewDoc(OverviewDoc overviewDoc) {
        this.m_overviewDoc = overviewDoc;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public OverviewDoc getOverviewDoc() {
        return this.m_overviewDoc;
    }

    public Operator getOperator() {
        return this.m_operator;
    }

    public CategoryBag getCategoryBag() {
        return this.m_categoryBag;
    }

    public IdentifierBag getIdentifierBag() {
        return this.m_identifierBag;
    }

    public AuthorizedName getAuthorizedName() {
        return this.m_authorizedName;
    }

    public void setOperator(Operator operator2) {
        this.m_operator = operator2;
    }

    public void addIdentifier(KeyedReference keyedReference) throws UDDIException {
        if (this.m_identifierBag == null) {
            this.m_identifierBag = new IdentifierBag();
        }
        this.m_identifierBag.add(keyedReference, keyedReference.getName());
    }

    public void addCategory(KeyedReference keyedReference) throws UDDIException {
        if (this.m_categoryBag == null) {
            this.m_categoryBag = new CategoryBag();
        }
        this.m_categoryBag.add(keyedReference);
    }

    public void addDescription(Description description) throws UDDIException {
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        this.m_identifierBag = identifierBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.m_categoryBag = categoryBag;
    }

    public boolean isHidden() {
        return this.m_isHidden;
    }

    public void setHidden(boolean bl) {
        this.m_isHidden = bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TModel)) {
            return false;
        }
        TModel tModel = (TModel)object;
        boolean bl = true;
        bl &= Util.isEqual(this.m_categoryBag, tModel.m_categoryBag);
        bl &= Util.isEqual(this.m_descriptions, tModel.m_descriptions);
        bl &= Util.isEqual(this.m_identifierBag, tModel.m_identifierBag);
        bl &= Util.isEqual(this.m_name, tModel.m_name);
        bl &= Util.isEqual(this.m_overviewDoc, tModel.m_overviewDoc);
        bl &= Util.isEqual(this.m_tModelKey, tModel.m_tModelKey);
        bl &= Util.isEqual(this.m_authorizedName, tModel.m_authorizedName);
        return bl &= Util.isEqual(this.m_operator, tModel.getOperator());
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tModel tModelKey=\"");
        if (this.m_tModelKey != null) {
            stringBuffer.append(this.m_tModelKey.toString());
        }
        stringBuffer.append("\"");
        if (this.m_authorizedName != null) {
            stringBuffer.append(" authorizedName=\"").append(this.m_authorizedName.toString()).append("\"");
        }
        if (this.m_operator != null) {
            stringBuffer.append(" operator=\"").append(this.m_operator.toString()).append("\"");
        }
        stringBuffer.append(">");
        if (this.m_name != null) {
            stringBuffer.append(this.m_name.toXML());
        }
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_overviewDoc != null) {
            stringBuffer.append(this.m_overviewDoc.toXML());
        }
        if (this.m_identifierBag != null) {
            stringBuffer.append(this.m_identifierBag.toXML());
        }
        if (this.m_categoryBag != null) {
            stringBuffer.append(this.m_categoryBag.toXML());
        }
        stringBuffer.append("</tModel>");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tModelKey:").append(this.m_tModelKey).append(", ");
        stringBuffer.append("authorizedName:").append(this.m_authorizedName).append(", ");
        stringBuffer.append("operator:").append(this.m_operator).append(", ");
        stringBuffer.append("name:").append(this.m_name).append(", ");
        stringBuffer.append("descriptions:").append(this.m_descriptions).append(", ");
        stringBuffer.append("overviewDoc:").append(this.m_overviewDoc).append(", ");
        stringBuffer.append("identifierBag:").append(this.m_identifierBag).append(", ");
        stringBuffer.append("categoryBag:").append(this.m_categoryBag);
        return stringBuffer.toString();
    }
}

