/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.BindingKey;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.InstanceDetails;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.UDDIBagObject;
import weblogic.auddi.util.Util;

public class TModelInstanceInfo
extends UDDIBagObject {
    private TModelKey m_tModelKey = null;
    private Descriptions m_descriptions = null;
    private InstanceDetails m_instanceDetails = null;
    private BindingKey m_bindingKey = null;

    public TModelInstanceInfo(TModelInstanceInfo tModelInstanceInfo) throws UDDIException {
        if (tModelInstanceInfo == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        if (tModelInstanceInfo.m_bindingKey != null) {
            this.m_bindingKey = new BindingKey(tModelInstanceInfo.m_bindingKey);
        }
        if (tModelInstanceInfo.m_tModelKey != null) {
            this.m_tModelKey = new TModelKey(tModelInstanceInfo.m_tModelKey);
        }
        if (tModelInstanceInfo.m_descriptions != null) {
            this.m_descriptions = new Descriptions(tModelInstanceInfo.m_descriptions);
        }
        if (tModelInstanceInfo.m_instanceDetails != null) {
            this.m_instanceDetails = new InstanceDetails(tModelInstanceInfo.m_instanceDetails);
        }
    }

    public TModelInstanceInfo(TModelKey tModelKey) {
        this.m_tModelKey = tModelKey;
    }

    public TModelInstanceInfo() {
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.m_descriptions == null) {
            this.m_descriptions = new Descriptions();
        }
        this.m_descriptions.add(description);
    }

    public void setInstanceDetails(InstanceDetails instanceDetails) {
        this.m_instanceDetails = instanceDetails;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.m_descriptions = descriptions;
    }

    public Descriptions getDescriptions() {
        return this.m_descriptions;
    }

    public InstanceDetails getInstanceDetails() {
        return this.m_instanceDetails;
    }

    public void setTModelKey(TModelKey tModelKey) {
        this.m_tModelKey = tModelKey;
    }

    public TModelKey getTModelKey() {
        return this.m_tModelKey;
    }

    public void setBindingKey(BindingKey bindingKey) {
        this.m_bindingKey = bindingKey;
    }

    public BindingKey getBindingKey() {
        return this.m_bindingKey;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TModelInstanceInfo)) {
            return false;
        }
        TModelInstanceInfo tModelInstanceInfo = (TModelInstanceInfo)object;
        boolean bl = true;
        bl &= this.m_descriptions == null ? tModelInstanceInfo.m_descriptions == null : this.m_descriptions.hasEqualContent(tModelInstanceInfo.m_descriptions);
        bl &= Util.isEqual(this.m_instanceDetails, tModelInstanceInfo.m_instanceDetails);
        return bl &= Util.isEqual(this.m_tModelKey, tModelInstanceInfo.m_tModelKey);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tModelInstanceInfo");
        stringBuffer.append(" tModelKey=\"").append(this.m_tModelKey.toString()).append("\"");
        stringBuffer.append(">");
        if (this.m_descriptions != null) {
            stringBuffer.append(this.m_descriptions.toXML());
        }
        if (this.m_instanceDetails != null) {
            stringBuffer.append(this.m_instanceDetails.toXML());
        }
        stringBuffer.append("</tModelInstanceInfo>");
        return stringBuffer.toString();
    }
}

