/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.InvalidKeyPassedException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.util.UUIDFormatValidator;
import weblogic.auddi.util.uuid.UUIDException;
import weblogic.auddi.util.uuid.UUIDGeneratorFactory;

public abstract class UDDIKey
extends UDDIListObject
implements Serializable {
    private String m_key = null;

    public UDDIKey() throws FatalErrorException {
        try {
            this.m_key = UUIDGeneratorFactory.getGenerator().uuidGen();
        }
        catch (UUIDException uUIDException) {
            throw new FatalErrorException("Failure while attempting to generate a UUID key", uUIDException);
        }
    }

    public UDDIKey(String string, boolean bl) throws InvalidKeyPassedException {
        if (!UUIDFormatValidator.validate(string, bl)) {
            throw new InvalidKeyPassedException(UDDIMessages.get("error.invalidKeyPassed." + this.getElementName(), string));
        }
        this.m_key = bl ? string.substring(5) : string;
    }

    public UDDIKey(UDDIKey uDDIKey) {
        this.m_key = uDDIKey.m_key;
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UDDIKey)) {
            return false;
        }
        UDDIKey uDDIKey = (UDDIKey)object;
        boolean bl = true;
        return bl &= this.m_key.equalsIgnoreCase(uDDIKey.m_key);
    }

    public int hashCode() {
        return this.getKey().toLowerCase().hashCode();
    }

    public String toString() {
        return this.getKey();
    }

    public String toXML() {
        return "<" + this.getElementName() + ">" + this.getKey() + "</" + this.getElementName() + ">";
    }

    abstract String getElementName();
}

