/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.response.BusinessInfo;
import weblogic.auddi.uddi.response.BusinessInfos;
import weblogic.auddi.uddi.response.ServiceInfo;
import weblogic.auddi.uddi.response.ServiceInfos;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;

public abstract class UDDIList
implements Serializable {
    private ArrayList m_list;
    private int m_index = -1;

    public List toList() {
        return this.m_list;
    }

    public UDDIList() {
        this.m_list = new ArrayList();
    }

    public UDDIList(UDDIList uDDIList) {
        if (uDDIList == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null") + " in class: " + this.getClass().getName());
        }
        this.m_list = new ArrayList();
        for (int i = 0; i < uDDIList.size(); ++i) {
            this.m_list.add(uDDIList.get(i));
        }
    }

    public boolean contains(Object object) {
        if (object != null) {
            return this.m_list.contains(object);
        }
        return false;
    }

    public void add(UDDIListObject uDDIListObject) {
        this.m_list.add(uDDIListObject);
    }

    public void remove(UDDIListObject uDDIListObject) throws UDDIException {
        this.m_list.remove(uDDIListObject);
    }

    public int size() {
        return this.m_list.size();
    }

    public UDDIListObject getVFirst() {
        if (this.m_list.size() == 0) {
            return null;
        }
        this.m_index = 0;
        return (UDDIListObject)this.m_list.get(this.m_index++);
    }

    public UDDIListObject getVNext() {
        if (this.m_index > -1 && this.m_index < this.m_list.size()) {
            return (UDDIListObject)this.m_list.get(this.m_index++);
        }
        return null;
    }

    public int getCount() {
        return this.m_list.size();
    }

    public UDDIListObject get(int n) {
        return (UDDIListObject)this.m_list.get(n);
    }

    public void sortByName() throws UDDIException {
        if (this instanceof BusinessInfos || this instanceof ServiceInfos) {
            this.sortByName(0, this.m_list.size() - 1);
        }
    }

    private void sortByName(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            String string = this.getName((n + n2) / 2);
            while (n3 <= n4) {
                while (n3 < n2 && this.getName(n3).compareToIgnoreCase(string) < 0) {
                    ++n3;
                }
                while (n4 > n && this.getName(n4).compareToIgnoreCase(string) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.sortByName(n, n4);
            }
            if (n3 < n2) {
                this.sortByName(n3, n2);
            }
        }
    }

    private String getName(int n) {
        if (n >= 0 && n < this.m_list.size()) {
            Object e = this.m_list.get(n);
            if (e instanceof ServiceInfo) {
                return ((ServiceInfo)e).getNames().getFirst().getName();
            }
            if (e instanceof BusinessInfo) {
                return ((BusinessInfo)e).getUniqueNames().getFirst().getName();
            }
            return null;
        }
        return null;
    }

    private void swap(int n, int n2) {
        if (n != n2 && n < this.m_list.size() && n2 < this.m_list.size()) {
            int n3;
            int n4;
            if (n < n2) {
                n4 = n;
                n3 = n2;
            } else {
                n4 = n2;
                n3 = n;
            }
            Object e = this.m_list.get(n3);
            this.m_list.remove(n3);
            this.m_list.add(n3, this.m_list.get(n4));
            this.m_list.remove(n4);
            this.m_list.add(n4, e);
        }
    }

    public boolean hasEqualContent(Object object) {
        UDDIListObject uDDIListObject;
        if (object == null) {
            return false;
        }
        if (!(object instanceof UDDIList)) {
            Logger.debug("UDDIList equals(): object recieved isn't a UDDIList:::" + object.getClass().getName() + ":::");
            return false;
        }
        UDDIList uDDIList = (UDDIList)object;
        if (this.size() != uDDIList.size()) {
            Logger.debug("UDDIList equals(): Size Mismatch :::" + this.size() + "!=" + uDDIList.size());
            return false;
        }
        UDDIListObject uDDIListObject2 = this.getVFirst();
        while (uDDIListObject2 != null) {
            block9: {
                uDDIListObject = uDDIList.getVFirst();
                while (uDDIListObject != null) {
                    if (!uDDIListObject2.equals(uDDIListObject)) {
                        uDDIListObject = uDDIList.getVNext();
                        continue;
                    }
                    break block9;
                }
                Logger.debug("First uddi list entry not found in second one:::" + uDDIListObject2.toString());
                return false;
            }
            uDDIListObject2 = this.getVNext();
        }
        uDDIListObject2 = uDDIList.getVFirst();
        while (uDDIListObject2 != null) {
            block10: {
                uDDIListObject = this.getVFirst();
                while (uDDIListObject != null) {
                    if (!uDDIListObject.equals(uDDIListObject2)) {
                        uDDIListObject = this.getVNext();
                        continue;
                    }
                    break block10;
                }
                Logger.debug("Second uddi list entry not found in first one:::" + uDDIListObject2.toString());
                return false;
            }
            uDDIListObject2 = uDDIList.getVNext();
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UDDIList)) {
            return false;
        }
        boolean bl = true;
        UDDIList uDDIList = (UDDIList)object;
        if (this.size() != uDDIList.size()) {
            Logger.debug("UDDIList equals(): Size Mismatch :::" + this.size() + "!=" + uDDIList.size());
            return false;
        }
        return bl &= Util.isEqual(this.m_list, uDDIList.m_list);
    }

    public String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && !string.equals("")) {
            stringBuffer.append("<" + string + ">");
        }
        UDDIListObject uDDIListObject = this.getVFirst();
        while (uDDIListObject != null) {
            stringBuffer.append(uDDIListObject.toXML());
            uDDIListObject = this.getVNext();
        }
        if (string != null && !string.equals("")) {
            stringBuffer.append("</" + string + ">");
        }
        return stringBuffer.toString();
    }
}

