/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.datastructure;

import java.util.HashMap;
import weblogic.auddi.uddi.LanguageErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Language;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.Names;

public class UniqueNames
extends Names {
    HashMap m_map = null;

    public UniqueNames() {
    }

    public UniqueNames(UniqueNames uniqueNames) throws UDDIException {
        if (uniqueNames == null) {
            throw new IllegalArgumentException(UDDIMessages.get("error.runtime.constructor.null"));
        }
        Name name = uniqueNames.getFirst();
        while (name != null) {
            this.add(new Name(name));
            name = uniqueNames.getNext();
        }
    }

    public void remove(Name name) throws UDDIException {
        super.remove(name);
        String string = name.getLang().toString();
        this.m_map.remove(string);
    }

    public void add(Name name) throws UDDIException {
        if (this.m_map == null) {
            this.m_map = new HashMap();
        }
        Language language = name.getLang();
        String string = null;
        if (language != null) {
            string = language.toString();
        }
        if (this.m_map.get(string) != null) {
            throw new LanguageErrorException(UDDIMessages.get("error.languageError.name", string));
        }
        super.add(name);
        this.m_map.put(string, name);
    }
}

