/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.request;

import weblogic.auddi.soap.SOAPWrapper;
import weblogic.auddi.uddi.BaseUDDIObject;
import weblogic.auddi.uddi.UDDIException;

public abstract class UDDIRequest
extends BaseUDDIObject {
    public static final String GENERIC = "2.0";
    public static final String XMLNS = "urn:uddi-org:api_v2";
    protected int maxRows = -1;
    public static final String WILDCARD_KEY = "00000000-0000-0000-0000-000000000000";
    public static final String WILDCARD_TMODEL_KEY = "uuid:00000000-0000-0000-0000-000000000000";
    private boolean m_isAPI = true;

    public boolean isAPI() {
        return this.m_isAPI;
    }

    public void setAPI(boolean bl) {
        this.m_isAPI = bl;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setMaxRows(String string) {
        Integer n = new Integer(string);
        this.maxRows = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String toSOAP() throws UDDIException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SOAPWrapper.makeSOAPString(this.toXML()));
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" generic=\"").append(GENERIC).append("\"");
        if (this.maxRows != -1) {
            stringBuffer.append(" maxRows=\"").append(this.maxRows).append("\"");
        }
        stringBuffer.append(" xmlns=\"").append(XMLNS).append("\"");
        return stringBuffer.toString();
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{new Boolean(this.m_isAPI), new Integer(this.maxRows)};
        Object[] objectArray2 = UDDIRequest.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_isAPI", "maxRows"};
        String[] stringArray2 = UDDIRequest.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

