/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.response;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.datastructure.UniqueNames;
import weblogic.auddi.uddi.response.ServiceInfo;
import weblogic.auddi.uddi.response.ServiceInfos;
import weblogic.auddi.util.Util;

public class BusinessInfo
extends UDDIListObject {
    private BusinessKey businessKey = null;
    private UniqueNames names = null;
    private Descriptions descriptions = null;
    private ServiceInfos serviceInfos = null;

    public UniqueNames getUniqueNames() {
        return this.names;
    }

    public BusinessKey getBusinessKey() {
        return this.businessKey;
    }

    public Descriptions getDescriptions() {
        return this.descriptions;
    }

    public ServiceInfos getServiceInfos() {
        return this.serviceInfos;
    }

    public BusinessInfo(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public BusinessInfo() {
    }

    public void setKey(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public void addName(Name name) throws UDDIException {
        if (this.names == null) {
            this.names = new UniqueNames();
        }
        this.names.add(name);
    }

    public void setNames(UniqueNames uniqueNames) throws UDDIException {
        this.names = uniqueNames;
    }

    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.descriptions == null) {
            this.descriptions = new Descriptions();
        }
        this.descriptions.add(description);
    }

    public void addServiceInfo(ServiceInfo serviceInfo) throws UDDIException {
        if (this.serviceInfos == null) {
            this.serviceInfos = new ServiceInfos();
        }
        this.serviceInfos.add(serviceInfo);
    }

    public void setServiceInfos(ServiceInfos serviceInfos) {
        this.serviceInfos = serviceInfos;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<businessInfo businessKey=\"");
        if (this.businessKey != null) {
            stringBuffer.append(this.businessKey.toString());
        }
        stringBuffer.append("\">");
        if (this.names != null) {
            stringBuffer.append(this.names.toXML(""));
        }
        if (this.descriptions != null) {
            stringBuffer.append(this.descriptions.toXML());
        }
        if (this.serviceInfos != null) {
            stringBuffer.append(this.serviceInfos.toXML());
        } else {
            stringBuffer.append("<serviceInfos />");
        }
        stringBuffer.append("</businessInfo>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BusinessInfo)) {
            return false;
        }
        BusinessInfo businessInfo = (BusinessInfo)object;
        boolean bl = true;
        bl &= Util.isEqual(this.businessKey, businessInfo.businessKey);
        bl &= Util.isEqual(this.names, businessInfo.names);
        bl &= Util.isEqual(this.descriptions, businessInfo.descriptions);
        return bl &= Util.isEqual(this.serviceInfos, businessInfo.serviceInfos);
    }
}

