/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.response;

import weblogic.auddi.uddi.UDDIErrorCodes;
import weblogic.auddi.util.Util;

public class ErrInfo {
    private int errno = -1;
    private String errMsg = null;
    private String errCode = null;

    public ErrInfo(int n) {
        this(n, null);
    }

    public ErrInfo() {
        this(-1, null);
    }

    public ErrInfo(String string) {
        this(-1, string);
    }

    public ErrInfo(int n, String string) {
        this.errno = n;
        this.errCode = UDDIErrorCodes.getCode(n);
        this.errMsg = string;
    }

    public int getErrCode() {
        return this.errno;
    }

    public String getErrCodeString() {
        return this.errCode;
    }

    public void setErrCode(String string) {
        this.errCode = string;
    }

    public void setErrMsg(String string) {
        this.errMsg = string;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errMsg == null) {
            stringBuffer.append("<errInfo errCode=\"" + this.errCode + "\">");
        } else {
            stringBuffer.append("<errInfo errCode=\"" + this.errCode + "\">");
            stringBuffer.append(Util.fixStringForXML(this.errMsg));
        }
        stringBuffer.append("</errInfo>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ErrInfo)) {
            return false;
        }
        ErrInfo errInfo = (ErrInfo)object;
        boolean bl = true;
        bl &= this.errno == errInfo.errno;
        bl &= Util.isEqual(this.errMsg, errInfo.errMsg);
        return bl &= Util.isEqual(this.errCode, errInfo.errCode);
    }
}

