/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.response;

import java.util.ArrayList;
import java.util.List;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.Names;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.response.SharedRelationships;
import weblogic.auddi.util.Util;

public class RelatedBusinessInfo
extends UDDIListObject {
    private BusinessKey businessKey = null;
    private Descriptions descriptions = null;
    private List m_sharedRelationships = new ArrayList();
    private Names names = null;

    public RelatedBusinessInfo(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public RelatedBusinessInfo() {
    }

    public void addName(Name name) {
        if (name == null) {
            return;
        }
        if (this.names == null) {
            this.names = new Names();
        }
        this.names.add(name);
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public void setNames(Names names) throws UDDIException {
        this.names = names;
    }

    public Names getNames() throws UDDIException {
        return this.names;
    }

    public void addDescription(Description description) throws UDDIException {
        if (description == null) {
            return;
        }
        if (this.descriptions == null) {
            this.descriptions = new Descriptions();
        }
        this.descriptions.add(description);
    }

    public void setDescriptions(Descriptions descriptions) throws UDDIException {
        this.descriptions = descriptions;
    }

    public void addSharedRelationships(SharedRelationships sharedRelationships) throws FatalErrorException {
        if (sharedRelationships == null) {
            return;
        }
        if (this.m_sharedRelationships.size() >= 2) {
            throw new FatalErrorException(UDDIMessages.get("error.tooManyOptions.sharedRelationships", "2"));
        }
        this.m_sharedRelationships.add(sharedRelationships);
    }

    public BusinessKey getBusinessKey() {
        return this.businessKey;
    }

    public Descriptions getDescriptions() {
        return this.descriptions;
    }

    public List getSharedRelationships() {
        return this.m_sharedRelationships;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RelatedBusinessInfo)) {
            return false;
        }
        RelatedBusinessInfo relatedBusinessInfo = (RelatedBusinessInfo)object;
        boolean bl = true;
        bl &= Util.isEqual(this.businessKey, relatedBusinessInfo.businessKey);
        bl &= Util.isEqual(this.descriptions, relatedBusinessInfo.descriptions);
        bl &= Util.isEqual(this.m_sharedRelationships, relatedBusinessInfo.m_sharedRelationships);
        return bl &= Util.isEqual(this.names, relatedBusinessInfo.names);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<relatedBusinessInfo>");
        if (this.businessKey != null) {
            stringBuffer.append(this.businessKey.toXML());
        }
        if (this.names != null) {
            stringBuffer.append(this.names.toXML());
        }
        if (this.descriptions != null) {
            stringBuffer.append(this.descriptions.toXML(""));
        }
        if (this.m_sharedRelationships != null) {
            for (int i = 0; i < this.m_sharedRelationships.size(); ++i) {
                stringBuffer.append(((SharedRelationships)this.m_sharedRelationships.get(i)).toXML());
            }
        }
        stringBuffer.append("</relatedBusinessInfo>");
        return stringBuffer.toString();
    }
}

