/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.response;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.response.ErrInfo;
import weblogic.auddi.util.Util;

public class Result
extends UDDIListObject {
    private int errno = -1;
    private ErrInfo errInfo = null;
    private String keyType = null;

    public Result(int n, String string) {
        this.errno = n;
        this.setErrInfo(new ErrInfo(n, string));
    }

    public Result(int n) {
        this(n, null);
    }

    public Result(UDDIException uDDIException) {
        this(uDDIException.getErrno(), uDDIException.getMessage());
    }

    public String getErrMsg() {
        String string = null;
        if (this.errInfo != null) {
            string = this.errInfo.getErrMsg();
        }
        return string;
    }

    public String getErrCode() {
        if (this.errInfo != null) {
            return this.errInfo.getErrCodeString();
        }
        return "";
    }

    public Result() {
        this(-1, null);
    }

    public int getErrno() {
        return this.errno;
    }

    public void setErrno(String string) {
        this.errno = Integer.parseInt(string);
    }

    public void setErrno(int n) {
        this.errno = n;
    }

    public void setErrInfo(ErrInfo errInfo) {
        this.errInfo = errInfo;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<result errno=\"" + this.getErrno() + "\"");
        if (this.keyType != null) {
            stringBuffer.append(" keyType=\"" + this.keyType + "\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.errInfo.toXML());
        stringBuffer.append("</result>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Result)) {
            return false;
        }
        Result result = (Result)object;
        boolean bl = true;
        bl &= this.errno == result.errno;
        return bl &= Util.isEqual(this.errInfo, result.errInfo);
    }
}

