/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.response;

import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.UDDIListObject;
import weblogic.auddi.uddi.datastructure.UniqueNames;
import weblogic.auddi.util.Util;

public class ServiceInfo
extends UDDIListObject {
    private BusinessKey businessKey;
    private ServiceKey serviceKey;
    private UniqueNames names;

    public ServiceInfo(BusinessKey businessKey, ServiceKey serviceKey) {
        this.businessKey = businessKey;
        this.serviceKey = serviceKey;
    }

    public ServiceInfo() {
        this.businessKey = null;
        this.serviceKey = null;
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public BusinessKey getBusinessKey() {
        return this.businessKey;
    }

    public void setServiceKey(ServiceKey serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public void addName(Name name) throws UDDIException {
        if (this.names == null) {
            this.names = new UniqueNames();
        }
        this.names.add(name);
    }

    public void setNames(UniqueNames uniqueNames) {
        this.names = uniqueNames;
    }

    public UniqueNames getNames() {
        return this.names;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo serviceInfo = (ServiceInfo)object;
        boolean bl = true;
        bl &= Util.isEqual(this.businessKey, serviceInfo.businessKey);
        bl &= Util.isEqual(this.names, serviceInfo.names);
        return bl &= Util.isEqual(this.serviceKey, serviceInfo.serviceKey);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<serviceInfo");
        if (this.businessKey != null) {
            stringBuffer.append(" businessKey=\"" + this.businessKey.toString() + "\"");
        }
        if (this.serviceKey != null) {
            stringBuffer.append(" serviceKey=\"" + this.serviceKey.toString() + "\"");
        }
        stringBuffer.append(">");
        if (this.names != null) {
            stringBuffer.append(this.names.toXML(""));
        }
        stringBuffer.append("</serviceInfo>");
        return stringBuffer.toString();
    }
}

