/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.soap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.soap.SOAPWrapper;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.response.DispositionReportResponse;
import weblogic.auddi.uddi.response.DispositionReportResponseHandler;
import weblogic.auddi.uddi.response.ErrorDispositionReportResponse;
import weblogic.auddi.uddi.response.Result;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.ParserFactory;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLUtil;

public class FaultWrapper {
    private boolean m_isNode;
    private String m_soapFaultString;
    private Node m_Node;
    UDDIException m_exception = null;
    DispositionReportResponse m_disposition = null;

    public FaultWrapper(UDDIException uDDIException) {
        this(uDDIException, null, "Client Error");
    }

    public FaultWrapper(Node node) throws UDDIException {
        Logger.trace("+FaultWrapper.CTOR(Node)");
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        this.m_isNode = true;
        this.m_Node = node;
        NodeList nodeList = this.m_Node.getOwnerDocument().getElementsByTagNameNS("*", "dispositionReport");
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("Node is not a valid fault message");
        }
        Node node2 = nodeList.item(0);
        DispositionReportResponseHandler dispositionReportResponseHandler = new DispositionReportResponseHandler();
        this.m_disposition = (DispositionReportResponse)dispositionReportResponseHandler.create(node2);
        Logger.trace("-FaultWrapper.CTOR(Node)");
    }

    public FaultWrapper(UDDIException uDDIException, String string, String string2) {
        Logger.trace("+FaultWrapper.CTOR(UDDIException,String,String)");
        if (uDDIException == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        this.m_isNode = false;
        this.m_exception = uDDIException;
        this.m_disposition = new ErrorDispositionReportResponse();
        Result result = new Result(this.m_exception);
        this.m_disposition.addResult(result);
        this.m_soapFaultString = SOAPWrapper.createFaultMessage(string, string2, result);
        Logger.trace("-FaultWrapper.CTOR(UDDIException,String,String)");
    }

    public DispositionReportResponse getDisposition() {
        return this.m_disposition;
    }

    public String toXML() {
        if (this.m_isNode) {
            return this.nodeToXML();
        }
        return this.exceptionToXML();
    }

    private String exceptionToXML() {
        Logger.trace("+FaultWrapper.exceptionToXML()");
        try {
            Document document = new ParserFactory().createDOMParserNS().parseRequest(this.m_soapFaultString);
            NodeList nodeList = document.getElementsByTagNameNS("*", "Fault");
            Node node = nodeList.item(0);
            Logger.trace("-FaultWrapper.exceptionToXML()");
            return XMLUtil.nodeToString(node);
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            Logger.trace("-FaultWrapper.exceptionToXML()");
            return "";
        }
    }

    private String nodeToXML() {
        Logger.trace("+FaultWrapper.nodeToXML()");
        NodeList nodeList = this.m_Node.getOwnerDocument().getElementsByTagNameNS("*", "Fault");
        Logger.trace("-FaultWrapper.nodeToXML()");
        return XMLUtil.nodeToString(nodeList.item(0));
    }
}

