/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.soap;

import java.io.IOException;
import java.net.URL;
import weblogic.auddi.soap.SOAPWrapperException;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.soap.UDDISOAPWrapper;
import weblogic.auddi.util.Logger;

public class SOAPClient {
    private static final int BUFF_SIZE = 2048;

    private SOAPClient() {
    }

    public static String sendUDDIRequest(String string) throws IOException, FatalErrorException, UDDIException {
        String string2 = System.getProperty("auddi.provider.url");
        String string3 = System.getProperty("PROXY_HOST");
        String string4 = System.getProperty("PROXY_PORT");
        if (string2 == null || string2.compareTo("") == 0) {
            Logger.Log(3, "SOAPClientDataSource error: auddi.provider.url must exist in uddi.properties");
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.property", "auddi.provider.url"));
        }
        String string5 = null;
        string5 = string3 == null || string3.compareTo("") == 0 || string4 == null || string4.compareTo("") == 0 ? SOAPClient.sendUDDIRequest(string2, string) : SOAPClient.sendUDDIRequest(string2, string3, Integer.parseInt(string4), string);
        return string5;
    }

    public static String sendUDDIRequest(String string, String string2) throws IOException, UDDIException {
        return SOAPClient.sendUDDIRequest(string, "", -1, string2);
    }

    public static String sendUDDIRequest(URL uRL, String string) throws IOException, UDDIException {
        return SOAPClient.sendUDDIRequest(uRL, "", -1, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendUDDIRequest(String string, String string2, int n, String string3) throws IOException, UDDIException {
        Logger.trace("+SOAPClient.sendUDDIRequest() : URL = '" + string + "'");
        URL uRL = new URL(string);
        Logger.Log(3, "URL = '" + uRL + "'");
        try {
            String string4;
            String string5 = string4 = SOAPClient.sendUDDIRequest(uRL, string2, n, string3);
            return string5;
        }
        finally {
            Logger.trace("-SOAPClient.sendUDDIRequest()");
        }
    }

    public static String sendUDDIRequest(URL uRL, String string, int n, String string2) throws IOException, UDDIException {
        Logger.trace("+SOAPClient.sendUDDIRequest(URL)");
        Logger.Log(3, "URL = '" + uRL + "'");
        try {
            String string3;
            String string4 = string3 = UDDISOAPWrapper.sendUDDIRequest(string2, uRL, string, n);
            return string4;
        }
        catch (SOAPWrapperException sOAPWrapperException) {
            Logger.error(sOAPWrapperException);
            throw new IOException(sOAPWrapperException.getMessage());
        }
        finally {
            Logger.trace("-SOAPClient.sendUDDIRequest(URL)");
        }
    }
}

