/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.soap;

import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.auddi.soap.SOAPWrapper;
import weblogic.auddi.soap.SOAPWrapperException;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.UnsupportedException;
import weblogic.auddi.uddi.datastructure.UDDIXMLHandler;
import weblogic.auddi.uddi.datastructure.UDDIXMLHandlerMaker;
import weblogic.auddi.uddi.request.UDDIRequest;
import weblogic.auddi.uddi.response.UDDIResponse;
import weblogic.auddi.uddi.xml.ParserWrapper;
import weblogic.auddi.uddi.xml.UDDIParser;
import weblogic.auddi.uddi.xml.UDDIParserFactory;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.ParserFactory;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLUtil;

public class UDDISOAPWrapper {
    private static UDDIParserFactory s_uddiParserFactory = new UDDIParserFactory();

    private UDDISOAPWrapper() {
    }

    public static String sendUDDIRequest(String string, URL uRL, String string2, int n) throws IOException, FatalErrorException, SOAPWrapperException {
        Logger.Log(4, "+weblogic.auddi.uddi.soap.UDDISOAPWrapper.sendUDDIRequest()");
        try {
            String string3;
            Document document = new ParserFactory().createSOAPParser().parseRequest(string);
            String string4 = string3 = SOAPWrapper.sendSOAPRequest(document.getDocumentElement(), uRL, string2, n);
            return string4;
        }
        catch (SchemaException schemaException) {
            throw new FatalErrorException("Failed to create Request from xml" + UDDISOAPWrapper.getAdditionalMessage(schemaException), schemaException);
        }
        finally {
            Logger.Log(4, "-weblogic.auddi.uddi.soap.UDDISOAPWrapper.sendUDDIRequest()");
        }
    }

    public static UDDIResponse createResponseFromSOAP(String string) throws UDDIException {
        UDDIParser uDDIParser = null;
        Logger.trace("+UDDISOAPWrapper.createResponseFromSOAP()");
        try {
            UDDIResponse uDDIResponse;
            uDDIParser = s_uddiParserFactory.getUDDIParser();
            Node node = uDDIParser.parseRequestIntoNode(string);
            if (node == null) {
                if (uDDIParser.hasFault()) {
                    UDDIXMLHandlerMaker uDDIXMLHandlerMaker = UDDIXMLHandlerMaker.getInstance();
                    UDDIXMLHandler uDDIXMLHandler = uDDIXMLHandlerMaker.makeHandler("Error");
                    UDDIResponse uDDIResponse2 = (UDDIResponse)uDDIXMLHandler.create(uDDIParser.getFaultNode());
                    Logger.Log(3, "handler : " + uDDIXMLHandler.getClass().getName());
                    Logger.Log(3, "response : " + uDDIResponse2.getClass().getName());
                    UDDIResponse uDDIResponse3 = uDDIResponse2;
                    return uDDIResponse3;
                }
                throw new FatalErrorException("No element found in the document");
            }
            Logger.Log(3, "***** PROCESSING *****");
            UDDIResponse uDDIResponse4 = uDDIResponse = UDDISOAPWrapper.createResponse(node);
            return uDDIResponse4;
        }
        catch (SchemaException schemaException) {
            throw new FatalErrorException("Failed to create Response from xml" + UDDISOAPWrapper.getAdditionalMessage(schemaException), schemaException);
        }
        finally {
            if (uDDIParser != null) {
                s_uddiParserFactory.returnUDDIParser(uDDIParser);
            }
            Logger.trace("-UDDISOAPWrapper.createResponseFromSOAP()");
        }
    }

    public static UDDIResponse createResponseFromXML(String string) throws UDDIException {
        Logger.trace("+UDDISOAPWrapper.createResponseFromXML()");
        try {
            UDDIResponse uDDIResponse;
            Document document = ParserWrapper.parseRequest(string, false);
            Element element = null;
            if (document == null || (element = document.getDocumentElement()) == null) {
                throw new FatalErrorException("No element found in the document");
            }
            UDDIResponse uDDIResponse2 = uDDIResponse = UDDISOAPWrapper.createResponse(element);
            return uDDIResponse2;
        }
        catch (SchemaException schemaException) {
            throw new FatalErrorException("Failed to create Response from xml" + UDDISOAPWrapper.getAdditionalMessage(schemaException), schemaException);
        }
        finally {
            Logger.trace("-UDDISOAPWrapper.createResponseFromXML()");
        }
    }

    private static UDDIResponse createResponse(Node node) throws UDDIException {
        Logger.trace("+weblogic.auddi.uddi.soap.UDDISOAPWrapper.createResponse()");
        UDDIXMLHandlerMaker uDDIXMLHandlerMaker = UDDIXMLHandlerMaker.getInstance();
        String string = node.getLocalName();
        UDDIXMLHandler uDDIXMLHandler = uDDIXMLHandlerMaker.makeHandler(string);
        UDDIResponse uDDIResponse = (UDDIResponse)uDDIXMLHandler.create(node);
        Logger.Log(3, "handler : " + uDDIXMLHandler.getClass().getName());
        Logger.Log(3, "response : " + uDDIResponse.getClass().getName());
        Logger.trace("-weblogic.auddi.uddi.soap.UDDISOAPWrapper.createResponse()");
        return uDDIResponse;
    }

    public static UDDIRequest createRequest(String string) throws UDDIException {
        UDDIParser uDDIParser = null;
        try {
            Logger.trace("+UDDISOAPWrapper.createRequest(String soapRequest)");
            uDDIParser = s_uddiParserFactory.getUDDIParser();
            Document document = uDDIParser.parseRequest(string);
            if (document == null || document.getDocumentElement() == null) {
                throw new FatalErrorException("No element found in the document");
            }
            Element element = document.getDocumentElement();
            UDDIRequest uDDIRequest = UDDISOAPWrapper.createRequest(element);
            Logger.debug("SOAP Message was successfully parsed as a UDDI request");
            UDDIRequest uDDIRequest2 = uDDIRequest;
            return uDDIRequest2;
        }
        catch (SchemaException schemaException) {
            Logger.error("SOAP Message could not be parsed as a UDDI Request. Original request follows:");
            Logger.error("[" + string + "]");
            throw new FatalErrorException("Failed to create Request from xml" + UDDISOAPWrapper.getAdditionalMessage(schemaException), schemaException);
        }
        finally {
            if (uDDIParser != null) {
                s_uddiParserFactory.returnUDDIParser(uDDIParser);
            }
            Logger.trace("-UDDISOAPWrapper.createRequest(String soapRequest)");
        }
    }

    private static String getAdditionalMessage(SchemaException schemaException) {
        Throwable throwable = schemaException.getCause();
        Throwable throwable2 = schemaException.getNestedException();
        String string = "";
        if (throwable != null) {
            string = string + " [ " + throwable.getMessage() + " ]";
        } else if (throwable2 != null) {
            string = string + " [ " + throwable2.getMessage() + " ]";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UDDIRequest createRequest(Node node) throws UDDIException {
        try {
            Logger.trace("+UDDISOAPWrapper.createRequest(Node)");
            if (node == null) {
                throw new FatalErrorException(UDDIMessages.get("error.fatalError.node"));
            }
            XMLUtil.removeWhiteSpace(node);
            Element element = (Element)node;
            Attr attr = element.getAttributeNode("generic");
            Logger.trace("generic = " + attr);
            if (attr != null && !attr.getNodeValue().toString().equals("1.0") && !attr.getNodeValue().toString().equals("2.0")) {
                throw new UnsupportedException(UDDIMessages.get("error.unsupported.generic"));
            }
            String string = node.getNodeName();
            Logger.debug("operation = " + string);
            UDDIXMLHandlerMaker uDDIXMLHandlerMaker = UDDIXMLHandlerMaker.getInstance();
            UDDIXMLHandler uDDIXMLHandler = uDDIXMLHandlerMaker.makeHandler(string);
            UDDIRequest uDDIRequest = (UDDIRequest)uDDIXMLHandler.create(node);
            Logger.debug("handler : " + uDDIXMLHandler.getClass().getName());
            Logger.debug("request : " + uDDIRequest.getClass().getName());
            UDDIRequest uDDIRequest2 = uDDIRequest;
            return uDDIRequest2;
        }
        finally {
            Logger.trace("-UDDISOAPWrapper.createRequest(Node)");
        }
    }
}

