/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeItem {
    private boolean m_canRead = true;
    private String m_key;
    protected String m_value;
    private String m_name;
    protected String m_tag;
    private DefaultMutableTreeNode m_treeNode;

    public NodeItem(String string, String string2, String string3) {
        this("KeyedReference", string, string2, string3);
    }

    public NodeItem(String string, String string2, String string3, String string4) {
        this.m_key = string2;
        if (this.m_key != null && this.m_key.equals("")) {
            this.m_key = null;
        }
        this.m_tag = string;
        this.m_value = string4;
        this.m_name = string3;
    }

    public void setTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_treeNode = defaultMutableTreeNode;
    }

    public void setTag(String string) {
        this.m_tag = string;
    }

    public void setKey(String string) {
        this.m_key = string;
    }

    public NodeItem(Node node) {
        this.parse(node);
    }

    public boolean isReadable() {
        return this.m_canRead;
    }

    public void setReadable(boolean bl) {
        this.m_canRead = bl;
    }

    private void parse(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string = ((Attr)namedNodeMap.item(i)).getName();
                if (string.equalsIgnoreCase("key") || string.equalsIgnoreCase("tmodelkey")) {
                    this.m_key = ((Attr)namedNodeMap.item(i)).getValue();
                    if (this.m_key.trim().equals("")) {
                        this.m_key = null;
                    }
                }
                if (string.equalsIgnoreCase("name") || string.equalsIgnoreCase("keyname")) {
                    this.m_name = ((Attr)namedNodeMap.item(i)).getValue();
                }
                if (!string.equalsIgnoreCase("value") && !string.equalsIgnoreCase("keyvalue")) continue;
                this.m_value = ((Attr)namedNodeMap.item(i)).getValue();
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getValue() {
        return this.m_value;
    }

    private TreeNode getLeaf(TreeNode treeNode) {
        if (treeNode.isLeaf()) {
            return treeNode;
        }
        return this.getLeaf(treeNode.getChildAt(0));
    }

    private TreeNode getAncestorWithKey(TreeNode treeNode) {
        Object object = ((DefaultMutableTreeNode)treeNode.getParent()).getUserObject();
        if (object instanceof NodeItem) {
            NodeItem nodeItem = (NodeItem)object;
            if (nodeItem.m_key != null) {
                return treeNode.getParent();
            }
            return this.getAncestorWithKey(treeNode.getParent());
        }
        return treeNode;
    }

    public String getKey() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        String string = this.m_key;
        if (string == null && this.m_treeNode != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)this.getAncestorWithKey(this.m_treeNode)).getUserObject()) != null) {
            NodeItem nodeItem = (NodeItem)object;
            string = nodeItem.getKey();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getKeyOld() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        String string = this.m_key;
        if (string == null && this.m_treeNode != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLeaf(this.m_treeNode)).getUserObject()) != null) {
            NodeItem nodeItem = (NodeItem)object;
            string = nodeItem.getKey();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String asTagString() {
        return "<" + this.m_tag + " key=\"" + this.getKey() + "\" name=\"" + this.m_name + "\" value=\"" + this.m_value + "\"/>";
    }

    public String asTagHead() {
        return "<" + this.m_tag + " key=\"" + this.getKey() + "\" name=\"" + this.m_name + "\" value=\"" + this.m_value + "\">";
    }

    public String asTagTail() {
        return "</" + this.m_tag + ">";
    }

    public String asKRString() {
        return "<keyedReference key=\"" + this.getKey() + "\" name=\"" + this.m_name + "\" value=\"" + this.m_value + "\"/>";
    }

    public String toString() {
        return this.m_name;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeItem) {
            NodeItem nodeItem = (NodeItem)object;
            return nodeItem.getName().equals(this.m_name) && nodeItem.getValue().equals(this.m_value);
        }
        return false;
    }
}

