/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.response.TModelDetailResponse;
import weblogic.auddi.uddi.soap.UDDISOAPWrapper;
import weblogic.auddi.uddi.util.StandardTModels;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;

public class StandardIdentifiers
extends StandardTModels {
    private static StandardIdentifiers s_instance = null;
    private static TModels s_tmodels = null;

    private StandardIdentifiers() throws UDDIException {
        try {
            String string = "stdIDS.xml";
            String string2 = "/weblogic/auddi/uddi/resources/";
            String string3 = string2 + string;
            InputStream inputStream = StandardTModels.class.getResourceAsStream(string3);
            String string4 = Util.getStreamContent(inputStream);
            Logger.Log(3, string4);
            TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)UDDISOAPWrapper.createResponseFromSOAP(string4);
            s_tmodels = tModelDetailResponse.getTModels();
            this.m_items = new HashMap();
            TModel tModel = s_tmodels.getFirst();
            while (tModel != null) {
                TModelKey tModelKey = tModel.getTModelKey();
                if (tModelKey != null) {
                    this.m_items.put(tModelKey.getKey(), tModel);
                }
                tModel = s_tmodels.getNext();
            }
        }
        catch (IOException iOException) {
            throw new FatalErrorException(UDDIMessages.get("error.loading.initial.data", iOException.getMessage()), iOException);
        }
    }

    public boolean isKeyFound(String string) {
        TModel tModel = s_tmodels.getFirst();
        while (tModel != null) {
            TModelKey tModelKey = tModel.getTModelKey();
            if (tModelKey.toString().toLowerCase().equals(string)) {
                return true;
            }
            tModel = s_tmodels.getNext();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardIdentifiers getInstance() throws UDDIException {
        if (s_instance != null) return s_instance;
        Class<StandardIdentifiers> clazz = StandardIdentifiers.class;
        synchronized (StandardIdentifiers.class) {
            if (s_instance != null) return s_instance;
            s_instance = new StandardIdentifiers();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Iterator iterator = StandardIdentifiers.getInstance().iterator();
        while (iterator.hasNext()) {
            TModel tModel = (TModel)iterator.next();
            System.out.println(tModel.getTModelKey() + ", " + tModel.getName());
        }
    }
}

