/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.Language;
import weblogic.auddi.uddi.xml.ParserWrapper;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;
import weblogic.auddi.xml.SchemaException;

public class StandardLanguages {
    private static StandardLanguages s_instance = null;
    private HashMap m_mapByCode = null;
    private HashMap m_mapByName = null;
    private Language[] m_list = null;

    private StandardLanguages() throws UDDIException {
        try {
            String string = "/weblogic/auddi/uddi/resources/";
            String string2 = "listISO369Languages.xml";
            String string3 = string + string2;
            InputStream inputStream = StandardLanguages.class.getResourceAsStream(string3);
            Logger.debug("ins : " + inputStream);
            String string4 = Util.getStreamContent(inputStream);
            Document document = ParserWrapper.parseRequest(string4, false);
            NodeList nodeList = document.getElementsByTagName("lang");
            this.m_mapByCode = new HashMap();
            this.m_mapByName = new HashMap();
            ArrayList<Language> arrayList = new ArrayList<Language>();
            Logger.debug("nodes : " + nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string5 = ((Attr)namedNodeMap.item(0)).getValue().toLowerCase();
                String string6 = ((Attr)namedNodeMap.item(1)).getValue();
                String string7 = ((Attr)namedNodeMap.item(2)).getValue();
                Language language = new Language(string5, string6, string7);
                this.m_mapByCode.put(string5, language);
                this.m_mapByName.put(string6, language);
                arrayList.add(language);
            }
            this.m_list = arrayList.toArray(new Language[0]);
        }
        catch (IOException iOException) {
            throw new FatalErrorException(UDDIMessages.get("error.loading.initial.data", iOException.getMessage()), iOException);
        }
        catch (SchemaException schemaException) {
            throw new FatalErrorException(UDDIMessages.get("error.loading.initial.data", schemaException.getMessage()), schemaException);
        }
    }

    public Language getByCode(String string) {
        Language language = (Language)this.m_mapByCode.get(string.toLowerCase());
        if (language == null) {
            language = (Language)this.m_mapByCode.get(string.toUpperCase());
        }
        return language;
    }

    public Language getByName(String string) {
        Language language = (Language)this.m_mapByName.get(string);
        if (language == null) {
            language = (Language)this.m_mapByName.get(string.toLowerCase());
        }
        if (language == null) {
            language = (Language)this.m_mapByName.get(string.toUpperCase());
        }
        return language;
    }

    public Language[] getLangs() {
        return this.m_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardLanguages getInstance() throws UDDIException {
        if (s_instance != null) return s_instance;
        Class<StandardLanguages> clazz = StandardLanguages.class;
        synchronized (StandardLanguages.class) {
            if (s_instance != null) return s_instance;
            s_instance = new StandardLanguages();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Language[] languageArray = StandardLanguages.getInstance().getLangs();
        for (int i = 0; i < languageArray.length; ++i) {
            System.out.println(languageArray[i].getLang() + " " + languageArray[i].getName() + " " + languageArray[i].getFamily());
        }
    }
}

