/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.util.XMLToTree;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.Util;
import weblogic.auddi.xml.SchemaException;

public abstract class StandardTModels {
    protected Map m_items = new HashMap();

    protected StandardTModels() {
    }

    public Map getItems() {
        return this.m_items;
    }

    public int getItemCount() {
        return this.m_items.size();
    }

    public Iterator iterator() {
        return this.m_items.values().iterator();
    }

    protected void loadFile(String string) throws UDDIException {
        Logger.debug("loading standard tmodels from : " + string);
        InputStream inputStream = null;
        try {
            inputStream = StandardTModels.class.getResourceAsStream(string);
            String string2 = Util.getStreamContent(inputStream);
            XMLToTree xMLToTree = new XMLToTree(string2);
            String string3 = xMLToTree.getKey();
            Logger.debug("Will put this TModel in Standard map: " + string3.toLowerCase());
            this.m_items.put(string3.toLowerCase(), xMLToTree);
        }
        catch (IOException iOException) {
            throw new FatalErrorException(UDDIMessages.get("error.loading.initial.data", iOException.getMessage()), iOException);
        }
        catch (SchemaException schemaException) {
            throw new FatalErrorException(UDDIMessages.get("error.loading.initial.data", schemaException.getMessage()), schemaException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public XMLToTree getItemByKey(String string) {
        if (string == null) {
            return null;
        }
        return (XMLToTree)this.m_items.get(string.toLowerCase());
    }

    public boolean isKeyFound(String string) {
        XMLToTree xMLToTree = this.getItemByKey(string);
        return xMLToTree != null;
    }

    public boolean isKeyValueFound(String string, String string2) {
        Logger.debug("Will seek to validate " + string2 + " in " + string);
        XMLToTree xMLToTree = this.getItemByKey(string);
        if (xMLToTree == null) {
            Logger.debug("XMLToTree was null");
            return false;
        }
        return xMLToTree.hasValue(string2);
    }
}

