/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.util.Hashtable;
import java.util.Iterator;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.TModelExt;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.util.UserCategories;
import weblogic.auddi.util.Logger;

public class UDDICoreTModels {
    public static final String UDDI_TYPES_TMODEL = "UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4";
    public static final String UDDI_NAICS_1997_TMODEL = "UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2";
    public static final String UDDI_UNSPSC_31_TMODEL = "UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384";
    public static final String UDDI_UNSPSC_7_TMODEL = "UUID:CD153257-086A-4237-B336-6BDCBDCC6634";
    public static final String UDDI_ISO_3166_1999_TMODEL = "UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88";
    public static final String UDDI_RELATIONSHIPS_TMODEL = "UUID:807A2C6A-EE22-470D-ADC7-E0424A337C03";
    public static final String UDDI_OPERATORS_TMODEL = "UUID:327A56F0-3299-4461-BC23-5CD513E95C55";
    public static final String UDDI_DUNS_TMODEL = "UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823";
    public static final String UDDI_THOMAS_REGISTRY_TMODEL = "UUID:B1B1BAF5-2329-43E6-AE13-BA8E97195039";
    public static final String UDDI_GENERAL_KEYWORDS_TMODEL = "UUID:A035A07C-F362-44DD-8F95-E2B134BF43B4";
    public static final String UDDI_OWNING_BUSINESS_TMODEL = "UUID:4064C064-6D14-4F35-8953-9652106476A9";
    public static final String UDDI_IS_REPLACED_BY_TMODEL = "UUID:E59AE320-77A5-11D5-B898-0004AC49CC1E";
    public static final String UDDI_SMTP_TMODEL = "UUID:93335D49-3EFB-48A0-ACEA-EA102B60DDC6";
    public static final String UDDI_FAX_TMODEL = "UUID:1A2B00BE-6E2C-42F5-875B-56F32686E0E7";
    public static final String UDDI_FTP_TMODEL = "UUID:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674";
    public static final String UDDI_TELEPHONE_TMODEL = "UUID:38E12427-5536-4260-A6F9-B5B530E63A07";
    public static final String UDDI_HTTP_TMODEL = "UUID:68DE9E80-AD09-469D-8A37-088422BFBC36";
    public static final String UDDI_HOMEPAGE_TMODEL = "UUID:4CEC1CEF-1F68-4B23-8CB7-8BAA763AEB89";
    private static UDDICoreTModels s_instance = null;
    private Hashtable m_CoreTModels = new Hashtable();
    private Hashtable m_OtherCoreTModels = null;
    private Hashtable m_businessIdentifiers = null;
    private Hashtable m_tModelIdentifiers = null;
    public static final String TYPE_CATEGORIZATION = "categorization";
    public static final String TYPE_IDENTIFIER = "identifier";
    public static final String TYPE_RELATIONSHIP = "relationship";
    public static final String TYPE_TRANSPORT = "transport";
    public static final String TYPE_PROTOCOL = "protocol";
    public static final String TYPE_SPECIFICATION = "specification";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UDDICoreTModels getInstance() throws UDDIException {
        if (s_instance != null) return s_instance;
        Class<UDDICoreTModels> clazz = UDDICoreTModels.class;
        synchronized (UDDICoreTModels.class) {
            if (s_instance != null) return s_instance;
            try {
                s_instance = new UDDICoreTModels();
            }
            catch (Exception exception) {
                throw new FatalErrorException("Problems during instantiation of UDDICoreTModels", exception);
            }
            return s_instance;
        }
    }

    private UDDICoreTModels() throws UDDIException {
        this.m_CoreTModels.put(UDDI_TYPES_TMODEL, new String[]{TYPE_CATEGORIZATION, "checked", "uddi-org:types", "tModel"});
        this.m_CoreTModels.put(UDDI_NAICS_1997_TMODEL, new String[]{TYPE_CATEGORIZATION, "checked", "ntis-gov:naics:1997", "businessEntity", "businessService", "tModel"});
        this.m_CoreTModels.put(UDDI_UNSPSC_31_TMODEL, new String[]{TYPE_CATEGORIZATION, "checked", "unspsc-org:unspsc:3.1", "businessEntity", "businessService", "tModel"});
        this.m_CoreTModels.put(UDDI_UNSPSC_7_TMODEL, new String[]{TYPE_CATEGORIZATION, "checked", "unspsc-org:unspsc:7.3", "businessEntity", "businessService", "tModel"});
        this.m_CoreTModels.put(UDDI_ISO_3166_1999_TMODEL, new String[]{TYPE_CATEGORIZATION, "checked", "uddi-org:iso-ch:3166:1999", "businessEntity", "businessService", "tModel"});
        this.m_CoreTModels.put(UDDI_GENERAL_KEYWORDS_TMODEL, new String[]{TYPE_CATEGORIZATION, "unchecked", "uddi-org:general_keywords", "businessEntity", "businessService", "tModel"});
        this.m_CoreTModels.put(UDDI_OWNING_BUSINESS_TMODEL, new String[]{TYPE_IDENTIFIER, "checked", "uddi-org:owningBusiness", "tModel"});
        this.m_CoreTModels.put(UDDI_RELATIONSHIPS_TMODEL, new String[]{TYPE_RELATIONSHIP, "unchecked", "uddi-org:relationships", "publisherAssertion"});
        this.m_CoreTModels.put(UDDI_OPERATORS_TMODEL, new String[]{TYPE_IDENTIFIER, "unchecked", "uddi-org:operators"});
        this.m_CoreTModels.put(UDDI_DUNS_TMODEL, new String[]{TYPE_IDENTIFIER, "unchecked", "dnb-com:D-U-N-S", "businessEntity", "tModel"});
        this.m_CoreTModels.put(UDDI_IS_REPLACED_BY_TMODEL, new String[]{TYPE_IDENTIFIER, "checked", "uddi-org:isReplacedBy", "businessEntity", "tModel"});
        this.m_CoreTModels.put(UDDI_THOMAS_REGISTRY_TMODEL, new String[]{TYPE_IDENTIFIER, "unchecked", "thomasregister-com:supplierID", "businessEntity", "tModel"});
        this.m_CoreTModels.put(UDDI_SMTP_TMODEL, new String[]{TYPE_TRANSPORT, "unchecked", "uddi-org:smtp", "bindingTemplate"});
        this.m_CoreTModels.put(UDDI_FAX_TMODEL, new String[]{TYPE_PROTOCOL, "unchecked", "uddi-org:fax", "bindingTemplate"});
        this.m_CoreTModels.put(UDDI_FTP_TMODEL, new String[]{TYPE_TRANSPORT, "unchecked", "uddi-org:ftp", "bindingTemplate"});
        this.m_CoreTModels.put(UDDI_TELEPHONE_TMODEL, new String[]{TYPE_SPECIFICATION, "unchecked", "uddi-org:telephone", "bindingTemplate"});
        this.m_CoreTModels.put(UDDI_HTTP_TMODEL, new String[]{TYPE_TRANSPORT, "unchecked", "uddi-org:http", "bindingTemplate"});
        this.m_CoreTModels.put(UDDI_HOMEPAGE_TMODEL, new String[]{TYPE_SPECIFICATION, "unchecked", "uddi-org:homepage", "bindingTemplate"});
        this.initOtherCoreTModels();
        this.initIdentifiers();
    }

    private void initOtherCoreTModels() throws UDDIException {
        this.m_OtherCoreTModels = new Hashtable();
        for (String string : this.m_CoreTModels.keySet()) {
            String string2 = this.getType(string);
            Logger.Log(3, " tModelKey = " + string + "; \ntype: " + string2);
            if (!string2.equals(TYPE_TRANSPORT) && !string2.equals(TYPE_SPECIFICATION) && !string2.equals(TYPE_PROTOCOL)) continue;
            this.m_OtherCoreTModels.put(string, this.m_CoreTModels.get(string));
        }
    }

    private void initIdentifiers() throws UDDIException {
        this.m_businessIdentifiers = new Hashtable();
        this.m_tModelIdentifiers = new Hashtable();
        for (String string : this.m_CoreTModels.keySet()) {
            String string2 = this.getType(string);
            Logger.Log(3, " tModelKey = " + string + "; \ntype: " + string2);
            if (!string2.equals(TYPE_IDENTIFIER) || string.equals(UDDI_OPERATORS_TMODEL)) continue;
            if (!string.equals(UDDI_OWNING_BUSINESS_TMODEL)) {
                this.m_businessIdentifiers.put(string, this.getName(string));
            }
            this.m_tModelIdentifiers.put(string, this.getName(string));
        }
    }

    public Hashtable getKeyNamePairForOtherCoreTModel() throws UDDIException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String string : this.m_OtherCoreTModels.keySet()) {
            String string2 = this.getName(string);
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    public Hashtable getKeyNamePairForTModelIdentifiers() throws UDDIException {
        this.m_tModelIdentifiers = new Hashtable();
        this.m_tModelIdentifiers.put(UDDI_DUNS_TMODEL, this.getName(UDDI_DUNS_TMODEL));
        this.m_tModelIdentifiers.put(UDDI_THOMAS_REGISTRY_TMODEL, this.getName(UDDI_THOMAS_REGISTRY_TMODEL));
        this.m_tModelIdentifiers.put(UDDI_IS_REPLACED_BY_TMODEL, this.getName(UDDI_IS_REPLACED_BY_TMODEL));
        this.m_tModelIdentifiers.put(UDDI_OWNING_BUSINESS_TMODEL, this.getName(UDDI_OWNING_BUSINESS_TMODEL));
        TModels tModels = UserCategories.getInstance().getPluggableTModels();
        if (tModels != null) {
            TModelExt tModelExt = (TModelExt)tModels.getFirst();
            while (tModelExt != null) {
                if (!tModelExt.getType().equalsIgnoreCase(TYPE_IDENTIFIER) || tModelExt.getApplicableScopes().size() == 0 || tModelExt.getApplicableScopes().contains("tModel")) {
                    // empty if block
                }
                this.m_tModelIdentifiers.put(tModelExt.getTModelKey().getKey(), tModelExt.getName().getName());
                tModelExt = (TModelExt)tModels.getNext();
            }
        }
        return this.m_tModelIdentifiers;
    }

    public Hashtable getKeyNamePairForBusinessIdentifiers() throws UDDIException {
        this.m_businessIdentifiers = new Hashtable();
        this.m_businessIdentifiers.put(UDDI_DUNS_TMODEL, this.getName(UDDI_DUNS_TMODEL));
        this.m_businessIdentifiers.put(UDDI_THOMAS_REGISTRY_TMODEL, this.getName(UDDI_THOMAS_REGISTRY_TMODEL));
        this.m_businessIdentifiers.put(UDDI_IS_REPLACED_BY_TMODEL, this.getName(UDDI_IS_REPLACED_BY_TMODEL));
        TModels tModels = UserCategories.getInstance().getPluggableTModels();
        if (tModels != null) {
            TModelExt tModelExt = (TModelExt)tModels.getFirst();
            while (tModelExt != null) {
                if (!tModelExt.getType().equalsIgnoreCase(TYPE_IDENTIFIER) || tModelExt.getApplicableScopes().size() == 0 || tModelExt.getApplicableScopes().contains("businessEntity")) {
                    // empty if block
                }
                this.m_tModelIdentifiers.put(tModelExt.getTModelKey().getKey(), tModelExt.getName().getName());
                tModelExt = (TModelExt)tModels.getNext();
            }
        }
        return this.m_businessIdentifiers;
    }

    public TModelExt getTModelExt(String string) throws UDDIException {
        if (this.isCoreTModel(string)) {
            TModelExt tModelExt = new TModelExt();
            tModelExt.setTModelKey(new TModelKey(string));
            tModelExt.setName(new Name(this.getName(string)));
            tModelExt.setChecked(this.isChecked(string));
            UDDICoreTModels.setTModelType(tModelExt, this.getType(string));
            this.setApplicableScopes(tModelExt);
            return tModelExt;
        }
        return null;
    }

    public static void setTModelType(TModelExt tModelExt, String string) throws UDDIException {
        tModelExt.setType(string);
    }

    private void setApplicableScopes(TModelExt tModelExt) {
        String[] stringArray = (String[])this.m_CoreTModels.get(tModelExt.getTModelKey().getKey().toUpperCase());
        if (stringArray != null && stringArray.length > 3) {
            for (int i = 3; i < stringArray.length; ++i) {
                tModelExt.addApplicableScope(stringArray[i]);
            }
        }
    }

    public String getName(String string) throws UDDIException {
        String[] stringArray = (String[])this.m_CoreTModels.get(string.toUpperCase());
        if (stringArray != null) {
            return stringArray[2];
        }
        return null;
    }

    public String getType(String string) throws UDDIException {
        String[] stringArray = (String[])this.m_CoreTModels.get(string.trim().toUpperCase());
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public boolean isChecked(String string) throws UDDIException {
        String[] stringArray = (String[])this.m_CoreTModels.get(string.toUpperCase());
        return stringArray != null && stringArray[1].equals("checked");
    }

    public boolean isCoreTModel(String string) throws UDDIException {
        return this.m_CoreTModels.get(string.toUpperCase()) != null;
    }

    public boolean isOtherCoreTModel(String string) throws UDDIException {
        return this.m_OtherCoreTModels.get(string.toUpperCase()) != null;
    }

    public boolean isGeneralKeywordsTModel(String string) throws UDDIException {
        return string.toUpperCase().equals(UDDI_GENERAL_KEYWORDS_TMODEL);
    }

    public boolean isOwningBusinessTModel(String string) throws UDDIException {
        return string.toUpperCase().equals(UDDI_OWNING_BUSINESS_TMODEL);
    }

    public boolean isReplacedByTModel(String string) throws UDDIException {
        return string.toUpperCase().equals(UDDI_IS_REPLACED_BY_TMODEL);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        UDDICoreTModels uDDICoreTModels = UDDICoreTModels.getInstance();
        Hashtable hashtable = uDDICoreTModels.m_CoreTModels;
        Hashtable hashtable2 = uDDICoreTModels.getKeyNamePairForOtherCoreTModel();
        Iterator iterator = hashtable.keySet().iterator();
        Iterator iterator2 = hashtable2.keySet().iterator();
        System.out.println("------------ UDDI Core TModels ------------ ");
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = uDDICoreTModels.getType(string2);
            String string3 = "unchecked";
            if (uDDICoreTModels.isChecked(string2)) {
                string3 = "checked";
            }
            String string4 = uDDICoreTModels.getName(string2);
            System.out.println(string2 + "; " + string + "; " + string3 + "; " + string4);
        }
        System.out.println("------------ UDDI Other Core TModels ------------ ");
        while (iterator2.hasNext()) {
            string2 = (String)iterator2.next();
            string = (String)hashtable2.get(string2);
            System.out.println(string2 + "; " + string);
        }
    }
}

