/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import weblogic.auddi.soap.SOAPWrapper;
import weblogic.auddi.uddi.AccountLimitExceededException;
import weblogic.auddi.uddi.AssertionNotFoundException;
import weblogic.auddi.uddi.AuthTokenExpiredException;
import weblogic.auddi.uddi.AuthTokenRequiredException;
import weblogic.auddi.uddi.BusyException;
import weblogic.auddi.uddi.EmptyBodyException;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.InvalidCompletionStatusException;
import weblogic.auddi.uddi.InvalidKeyPassedException;
import weblogic.auddi.uddi.InvalidProjectionException;
import weblogic.auddi.uddi.InvalidValueException;
import weblogic.auddi.uddi.LanguageErrorException;
import weblogic.auddi.uddi.MessageTooLargeException;
import weblogic.auddi.uddi.NameTooLongException;
import weblogic.auddi.uddi.PublisherCancelledException;
import weblogic.auddi.uddi.RequestDeniedException;
import weblogic.auddi.uddi.SecretUnknownException;
import weblogic.auddi.uddi.TooManyOptionsException;
import weblogic.auddi.uddi.TransferAbortedException;
import weblogic.auddi.uddi.UDDIErrorCodes;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UnknownUserException;
import weblogic.auddi.uddi.UnrecognizedVersionException;
import weblogic.auddi.uddi.UnsupportedException;
import weblogic.auddi.uddi.UserMismatchException;
import weblogic.auddi.uddi.ValueNotAllowedException;
import weblogic.auddi.uddi.response.ErrorDispositionReportResponse;
import weblogic.auddi.uddi.response.Result;
import weblogic.auddi.uddi.response.Results;
import weblogic.auddi.uddi.soap.FaultWrapper;

public class UDDIExceptionMapper {
    private UDDIExceptionMapper() {
    }

    public static ErrorDispositionReportResponse toDispositionReport(UDDIException uDDIException) {
        FaultWrapper faultWrapper = new FaultWrapper(uDDIException);
        ErrorDispositionReportResponse errorDispositionReportResponse = (ErrorDispositionReportResponse)faultWrapper.getDisposition();
        return errorDispositionReportResponse;
    }

    public static String toDispositionXML(UDDIException uDDIException) {
        FaultWrapper faultWrapper = new FaultWrapper(uDDIException);
        String string = faultWrapper.toXML();
        return string;
    }

    public static String toDispositionSOAP(UDDIException uDDIException) {
        String string = UDDIExceptionMapper.toDispositionXML(uDDIException);
        String string2 = SOAPWrapper.makeSOAPString(string);
        return string2;
    }

    public static UDDIException toException(ErrorDispositionReportResponse errorDispositionReportResponse) {
        Result result;
        UDDIException uDDIException = null;
        Results results = errorDispositionReportResponse.getResults();
        if (results != null && results.size() > 0 && (result = results.getFirst()) != null) {
            int n;
            String string;
            int n2 = result.getErrno();
            String string2 = result.getErrMsg();
            if (string2.startsWith(string = UDDIErrorCodes.getMessage(n2)) && (string2 = string2.substring(n = string.length())).startsWith(" '") && string2.endsWith("'")) {
                int n3 = 2;
                int n4 = string2.length() - 1;
                string2 = string2.substring(n3, n4);
            }
            switch (n2) {
                case 10160: {
                    uDDIException = new AccountLimitExceededException(string2);
                    break;
                }
                case 30000: {
                    uDDIException = new AssertionNotFoundException(string2);
                    break;
                }
                case 10110: {
                    uDDIException = new AuthTokenExpiredException(string2);
                    break;
                }
                case 10120: {
                    uDDIException = new AuthTokenRequiredException(string2);
                    break;
                }
                case 10400: {
                    uDDIException = new BusyException(string2);
                    break;
                }
                case 90001: {
                    uDDIException = new EmptyBodyException(string2);
                    break;
                }
                case 10500: {
                    uDDIException = new FatalErrorException(string2);
                    break;
                }
                case 30100: {
                    uDDIException = new InvalidCompletionStatusException(string2);
                    break;
                }
                case 10210: {
                    uDDIException = new InvalidKeyPassedException(string2);
                    break;
                }
                case 20230: {
                    uDDIException = new InvalidProjectionException(string2);
                    break;
                }
                case 20200: {
                    uDDIException = new InvalidValueException(string2);
                    break;
                }
                case 10060: {
                    uDDIException = new LanguageErrorException(string2);
                    break;
                }
                case 30110: {
                    uDDIException = new MessageTooLargeException(string2);
                    break;
                }
                case 10020: {
                    uDDIException = new NameTooLongException(string2);
                    break;
                }
                case 30220: {
                    uDDIException = new PublisherCancelledException(string2);
                    break;
                }
                case 30210: {
                    uDDIException = new RequestDeniedException(string2);
                    break;
                }
                case 30230: {
                    uDDIException = new SecretUnknownException(string2);
                    break;
                }
                case 10030: {
                    uDDIException = new TooManyOptionsException(string2);
                    break;
                }
                case 30200: {
                    uDDIException = new TransferAbortedException(string2);
                    break;
                }
                case 10150: {
                    uDDIException = new UnknownUserException(string2);
                    break;
                }
                case 10040: {
                    uDDIException = new UnrecognizedVersionException(string2);
                    break;
                }
                case 10050: {
                    uDDIException = new UnsupportedException(string2);
                    break;
                }
                case 10140: {
                    uDDIException = new UserMismatchException(string2);
                    break;
                }
                case 20210: {
                    uDDIException = new ValueNotAllowedException(string2);
                }
            }
        }
        return uDDIException;
    }
}

