/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.util.StringTokenizer;

public class UUIDFormatValidator {
    private static boolean isValid(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Character c = new Character(string.charAt(i));
            if (Character.isLetterOrDigit(c.charValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean isWellFormed(String string, int n, boolean bl) {
        if (bl) {
            return string.equalsIgnoreCase("uuid:");
        }
        switch (n) {
            case 1: {
                if (string.length() != 8) {
                    return false;
                }
                return UUIDFormatValidator.isValid(string);
            }
            case 2: 
            case 3: 
            case 4: {
                if (string.length() != 4) {
                    return false;
                }
                return UUIDFormatValidator.isValid(string);
            }
            case 5: {
                if (string.length() != 12) {
                    return false;
                }
                return UUIDFormatValidator.isValid(string);
            }
        }
        return false;
    }

    public static boolean validate(String string) {
        return UUIDFormatValidator.validate(string, false);
    }

    public static boolean validate(String string, boolean bl) {
        if (bl && string.length() != 41) {
            return false;
        }
        if (!bl && string.length() != 36) {
            return false;
        }
        String string2 = "";
        if (bl) {
            String string3 = string.substring(0, 5);
            string = string.substring(5);
            if (!UUIDFormatValidator.isWellFormed(string3, 0, bl)) {
                return false;
            }
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-", false);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (UUIDFormatValidator.isWellFormed(string2, ++n, false)) continue;
            return false;
        }
        return n == 5;
    }
}

