/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelExt;
import weblogic.auddi.uddi.datastructure.TModelHandler;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.datastructure.UDDIXMLHandlerMaker;
import weblogic.auddi.uddi.util.NodeItem;
import weblogic.auddi.uddi.util.StandardTModels;
import weblogic.auddi.uddi.util.XMLToTree;
import weblogic.auddi.uddi.xml.ParserWrapper;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.util.Util;
import weblogic.auddi.xml.SchemaException;

public class UserCategories
extends StandardTModels {
    private static UserCategories s_instance = null;
    private TModels m_tModelExts = null;

    private UserCategories() throws UDDIException {
        Logger.trace("+UserCategories.CTOR()");
        this.m_tModelExts = new TModels();
        String string = PropertyManager.getRuntimeProperty("pluggableTModel.file.list");
        Logger.debug("fileList: " + string);
        if (string != null && !string.trim().equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("")) continue;
                this.process(this.validateFile(string2));
            }
        }
        Logger.trace("-UserCategories.CTOR()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserCategories getInstance() throws UDDIException {
        if (s_instance != null) return s_instance;
        Class<UserCategories> clazz = UserCategories.class;
        synchronized (UserCategories.class) {
            if (s_instance != null) return s_instance;
            s_instance = new UserCategories();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public Document validateFile(String string) throws UDDIException {
        Logger.trace("+UserCategories.validateFile()");
        try {
            if (!string.equals("")) {
                File file = new File(string);
                String string2 = Util.getFileContent(file);
                Document document = this.validateContent(string2);
                Logger.trace("-UserCategories.validateFile()");
                return document;
            }
        }
        catch (IOException iOException) {
            Logger.trace("-EXCEPTION(FatalErrorException) UserCategories.validateFile()");
            throw new FatalErrorException(UDDIMessages.get("error.loading.pluggableTModel", iOException.getMessage()));
        }
        return null;
    }

    public Document validateContent(String string) throws UDDIException {
        Logger.trace("+UserCategories.validateContent()");
        try {
            if (string != null) {
                Document document = ParserWrapper.parseRequest(string, true);
                Logger.trace("-UserCategories.validateFormat()");
                return document;
            }
        }
        catch (SchemaException schemaException) {
            Exception exception = (Exception)schemaException.getNestedException();
            String string2 = schemaException.getMessage();
            if (string2 == null) {
                string2 = exception != null && exception.getMessage() != null ? exception.getMessage() : " schema vilation - invalid file format";
            }
            Logger.trace("-EXCEPTION(FatalErrorException) UserCategories.validateContent()");
            throw new FatalErrorException(UDDIMessages.get("error.loading.pluggableTModel", string2));
        }
        return null;
    }

    public void process(Document document) throws UDDIException {
        String string;
        Logger.trace("+UserCategories.process()");
        TModel tModel = null;
        TModelExt tModelExt = null;
        NodeList nodeList = null;
        NodeList nodeList2 = document.getElementsByTagName("tModel");
        if (nodeList2.getLength() == 0) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "tModel"));
        }
        Node node = nodeList2.item(0);
        UDDIXMLHandlerMaker uDDIXMLHandlerMaker = UDDIXMLHandlerMaker.getInstance();
        TModelHandler tModelHandler = (TModelHandler)uDDIXMLHandlerMaker.makeHandler("tModel");
        tModel = (TModel)tModelHandler.create(node);
        if (tModel.getTModelKey() == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "tModelKey"));
        }
        if (tModel.getName() == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "tModel name"));
        }
        Logger.debug("create TModelExt: ");
        tModelExt = new TModelExt(tModel);
        document.getDocumentElement().removeChild(node);
        Element element = document.getDocumentElement();
        if (element.getAttributeNode("checked") != null) {
            string = element.getAttributeNode("checked").getNodeValue();
            boolean bl = Boolean.valueOf(string);
            tModelExt.setChecked(bl);
        } else {
            tModelExt.setChecked(false);
        }
        Logger.trace("checked tModel: " + tModelExt.isChecked());
        if (element.getAttributeNode("type") == null) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "type attribute"));
        }
        string = element.getAttributeNode("type").getNodeValue();
        tModelExt.setType(string);
        nodeList2 = document.getElementsByTagName("applicability");
        if (nodeList2.getLength() > 0) {
            node = nodeList2.item(0);
            nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    element = (Element)nodeList.item(i);
                    if (element.getNodeType() == 8 || !element.getNodeName().equals("scope") || element.getChildNodes().item(0) == null) continue;
                    String string2 = element.getChildNodes().item(0).getNodeValue();
                    Logger.debug("adding applicable scope: " + string2);
                    tModelExt.addApplicableScope(string2);
                }
            }
            document.getDocumentElement().removeChild(node);
        }
        this.m_tModelExts.add(tModelExt);
        if (!tModelExt.isChecked()) {
            return;
        }
        nodeList2 = document.getElementsByTagName("category");
        int n = nodeList2.getLength();
        NodeList nodeList3 = document.getElementsByTagName("categories");
        int n2 = nodeList3.getLength();
        if (n2 == 0) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "categories in pluggable tModel"));
        }
        if (n == 0) {
            throw new FatalErrorException(UDDIMessages.get("error.fatalError.missingElement", "category"));
        }
        node = nodeList3.item(0);
        document.getDocumentElement().removeChild(node);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            document.getDocumentElement().appendChild(node);
        }
        XMLToTree xMLToTree = new XMLToTree(document);
        DefaultMutableTreeNode defaultMutableTreeNode = xMLToTree.getRoot();
        NodeItem nodeItem = (NodeItem)defaultMutableTreeNode.getUserObject();
        nodeItem.setKey(tModelExt.getTModelKey().getKey());
        nodeItem.setName(tModelExt.getName().getName());
        this.m_items.put(tModelExt.getTModelKey().getKey().toLowerCase(), xMLToTree);
        Logger.trace("-UserCategories.process()");
    }

    public TModels getPluggableTModels() {
        return this.m_tModelExts;
    }

    public TModelExt getTModelExt(String string) {
        Logger.trace("+UserCategories.getTModelExt()");
        Logger.trace("tModels.size(): " + this.m_tModelExts.size());
        if (string == null) {
            return null;
        }
        TModelExt tModelExt = (TModelExt)this.m_tModelExts.getFirst();
        while (tModelExt != null) {
            if (tModelExt.getTModelKey().getKey().equalsIgnoreCase(string)) {
                Logger.debug("found: " + string);
                Logger.trace("-UserCategories.getTModelExt()");
                return tModelExt;
            }
            tModelExt = (TModelExt)this.m_tModelExts.getNext();
        }
        Logger.debug("not found: " + string);
        Logger.trace("-UserCategories.getTModelExt()");
        return null;
    }

    public HashMap getCategorizationItems() {
        HashMap hashMap = new HashMap();
        for (String string : this.m_items.keySet()) {
            TModelExt tModelExt = this.getTModelExt(string);
            if (tModelExt == null || tModelExt.getType() == null || !tModelExt.isChecked() || !tModelExt.getType().equalsIgnoreCase("categorization")) continue;
            hashMap.put(string, this.m_items.get(string));
        }
        return hashMap;
    }

    public HashMap getIdentifierItems() {
        HashMap<String, TModelExt> hashMap = new HashMap<String, TModelExt>();
        for (String string : this.m_items.keySet()) {
            TModelExt tModelExt = this.getTModelExt(string);
            if (tModelExt == null || tModelExt.getType() == null || !tModelExt.getType().equalsIgnoreCase("identifier")) continue;
            hashMap.put(string, tModelExt);
        }
        return hashMap;
    }
}

