/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.uddi.util.NodeItem;
import weblogic.auddi.uddi.xml.ParserWrapper;
import weblogic.auddi.util.Util;
import weblogic.auddi.xml.SchemaException;

public class XMLToTree {
    private DefaultMutableTreeNode m_root;
    private Map entryMap = new HashMap();

    public XMLToTree(File file) throws IOException, SchemaException {
        this(Util.getFileContent(file));
    }

    public XMLToTree(String string) throws SchemaException {
        Document document = ParserWrapper.parseRequest(string, false);
        this.parse(document);
    }

    public XMLToTree(Document document) {
        this.parse(document);
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getNodeName();
        this.m_root = new DefaultMutableTreeNode(string);
        this.parse(element, this.m_root);
        ((NodeItem)this.m_root.getUserObject()).setReadable(false);
    }

    private void parse(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        NodeItem nodeItem = new NodeItem(node);
        String string = nodeItem.getValue();
        if (string != null && !string.equals("")) {
            this.entryMap.put(string, nodeItem);
        }
        defaultMutableTreeNode.setUserObject(nodeItem);
        nodeItem.setTreeNode(defaultMutableTreeNode);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string2 = node.getNodeName();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                if (node2.getNodeType() != 3) {
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                this.parse(node2, defaultMutableTreeNode2);
            }
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return this.m_root;
    }

    public String getKey() {
        NodeItem nodeItem = (NodeItem)this.getRoot().getUserObject();
        String string = nodeItem.getKey();
        return string;
    }

    public static JFrame getJTreeFrame(XMLToTree[] xMLToTreeArray, String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        final JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                NodeItem nodeItem;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof NodeItem && (nodeItem = (NodeItem)object) != null && nodeItem.isReadable()) {
                    System.out.println(nodeItem.asKRString());
                }
            }
        });
        for (int i = 0; i < xMLToTreeArray.length; ++i) {
            defaultMutableTreeNode.add(xMLToTreeArray[i].getRoot());
        }
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setBounds(100, 50, 700, 1000);
        return jFrame;
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayList<XMLToTree> arrayList = new ArrayList<XMLToTree>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            System.out.println("Processing " + stringArray[i] + "...");
            XMLToTree xMLToTree = new XMLToTree(file);
            System.out.println("Done!");
            arrayList.add(xMLToTree);
        }
        JFrame jFrame = XMLToTree.getJTreeFrame(arrayList.toArray(new XMLToTree[0]), "XMLToTree");
        jFrame.setVisible(true);
    }

    public NodeItem getNodeItem(String string) {
        return (NodeItem)this.entryMap.get(string);
    }

    public boolean hasValue(String string) {
        NodeItem nodeItem = (NodeItem)this.entryMap.get(string);
        return nodeItem != null;
    }
}

