/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;

class UDDIEntityResolver
implements EntityResolver {
    private static final String UDDI_SCHEMA_REF = "/uddi_v2.xsd";
    private static final String UDDI_SCHEMA_SOURCE = "uddi.schema.resource";
    private static final String XML_SCHEMA_REF = "http://www.w3.org/2001/xml.xsd";
    private static final String XML_SCHEMA_SOURCE = "xml.schema.resource";
    private static byte[] s_uddischema;
    private static byte[] s_xmlschema;

    public UDDIEntityResolver() {
        Logger.trace("+UDDIEntityResolver.CTOR()");
        InputStream inputStream = null;
        if (s_uddischema == null) {
            int n;
            int n2;
            String string = PropertyManager.getRuntimeProperty(UDDI_SCHEMA_SOURCE);
            if (string == null) {
                throw new RuntimeException(UDDIMessages.get("error.resource.notfound", UDDI_SCHEMA_SOURCE));
            }
            inputStream = this.getClass().getResourceAsStream(string);
            try {
                s_uddischema = new byte[inputStream.available()];
                n2 = 0;
                while ((n = inputStream.read()) != -1) {
                    UDDIEntityResolver.s_uddischema[n2++] = (byte)n;
                }
            }
            catch (IOException iOException) {
                Logger.debug(iOException);
            }
            string = PropertyManager.getRuntimeProperty(XML_SCHEMA_SOURCE);
            if (string == null) {
                throw new RuntimeException(UDDIMessages.get("error.resource.notfound", XML_SCHEMA_SOURCE));
            }
            inputStream = this.getClass().getResourceAsStream(string);
            try {
                s_xmlschema = new byte[inputStream.available()];
                n2 = 0;
                while ((n = inputStream.read()) != -1) {
                    UDDIEntityResolver.s_xmlschema[n2++] = (byte)n;
                }
            }
            catch (IOException iOException) {
                Logger.debug(iOException);
            }
        }
        Logger.trace("-UDDIEntityResolver.CTOR()");
    }

    public InputSource resolveEntity(String string, String string2) {
        Logger.trace("+UDDIEntityResolver.resolveEntity() - systemId: " + string2);
        if (string2 == null) {
            Logger.trace("-UDDIEntityResolver.resolveEntity() - systemId was NULL");
            return null;
        }
        if (string2.startsWith("file://")) {
            int n = string2.lastIndexOf(47);
            string2 = string2.substring(n);
        }
        Object var3_4 = null;
        BufferedInputStream bufferedInputStream = null;
        if (string2.equals(UDDI_SCHEMA_REF)) {
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(s_uddischema));
        } else if (string2.equals(XML_SCHEMA_REF)) {
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(s_xmlschema));
        }
        Logger.trace("-UDDIEntityResolver.resolveEntity() returning :" + (bufferedInputStream == null ? "Null" : "Not Null"));
        return bufferedInputStream == null ? null : new InputSource(bufferedInputStream);
    }
}

