/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.xml;

import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.DomBuilder;
import weblogic.auddi.xml.SOAPParser;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLParser;

public class UDDIParser
extends XMLParser {
    public static final String XML_ENC = "UTF-8";
    public static final String IGNORE_ENCODING = "auddi.encoding.ignore";
    private DomBuilder m_v_parser;
    private SOAPParser m_SOAPParser;
    private boolean m_ignoreEncoding;

    public UDDIParser(SOAPParser sOAPParser, DomBuilder domBuilder) throws SchemaException {
        Logger.trace("+UDDIParser.CTOR()");
        this.m_v_parser = domBuilder;
        this.m_SOAPParser = sOAPParser;
        this.m_ignoreEncoding = Boolean.getBoolean(System.getProperty(IGNORE_ENCODING));
        Logger.trace("-UDDIParser.CTOR()");
    }

    public Document parseRequest(String string) throws SchemaException {
        try {
            Logger.trace("+UDDIParser.parseRequest()");
            Document document = this.m_SOAPParser.parseRequest(string);
            String string2 = this.m_SOAPParser.getPayLoad(document);
            if (string2 == null) {
                Document document2 = null;
                return document2;
            }
            document = this.m_v_parser.parse(string2);
            String string3 = this.m_SOAPParser.getEncoding();
            if (!this.m_ignoreEncoding && !XML_ENC.equals(string3) && string3 != null && string3.trim().length() != 0) {
                throw new SchemaException(UDDIMessages.get("error.fatalError.xmlEncoding", string3, XML_ENC));
            }
            Document document3 = document;
            return document3;
        }
        catch (SAXException sAXException) {
            Logger.trace("-EXCEPTION(SAXException) UDDIParser.parseRequest()");
            throw new SchemaException(sAXException);
        }
        catch (IOException iOException) {
            Logger.trace("-EXCEPTION(IOException) UDDIParser.parseRequest()");
            throw new SchemaException(iOException);
        }
        finally {
            Logger.trace("-UDDIParser.parseRequest()");
        }
    }

    public Node parseRequestIntoNode(String string) throws SchemaException {
        Document document = this.m_SOAPParser.parseRequest(string);
        Node node = this.m_SOAPParser.getPayLoadNode(document);
        return node;
    }

    public boolean hasFault() {
        return this.m_SOAPParser.hasFault();
    }

    public Node getFaultNode() {
        return this.m_SOAPParser.getFaultNode();
    }
}

