/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.xml.UDDIEntityResolver;
import weblogic.auddi.uddi.xml.UDDIParser;
import weblogic.auddi.uddi.xml.UDDIParserPool;
import weblogic.auddi.util.ConnectException;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.xml.DomBuilder;
import weblogic.auddi.xml.ParserFactory;
import weblogic.auddi.xml.SOAPParser;
import weblogic.auddi.xml.SchemaException;

public class UDDIParserFactory
extends ParserFactory {
    public static final String UDDI_SCHEMA_REF = "/uddi_v2.xsd";
    public static final int DEFAULT_INITIAL_SIZE = 10;
    public static final int DEFAULT_MAX_SIZE = 50;
    public static final int DEFAULT_INCREMENT = 2;
    public static final int DEFAULT_SYSTEM_MAX_SIZE = 1000;
    public static final String INITIAL_SIZE_PROPERTY = "uddi.parser.pool.initialsize";
    public static final String MAX_SIZE_PROPERTY = "uddi.parser.pool.maxsize";
    public static final String INCREMENT_PROPERTY = "uddi.parser.pool.increment";
    public static final String SYSTEM_MAX_SIZE_PROPERTY = "uddi.parser.pool.system.maxsize";
    private static UDDIParserPool m_pool;
    private Map parserMap;
    private ParserFactory m_parserFactory = new ParserFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDIParserFactory() {
        Logger.trace("+UDDIParserFactory.CTOR()");
        try {
            Class<UDDIParserFactory> clazz = UDDIParserFactory.class;
            synchronized (UDDIParserFactory.class) {
                if (m_pool == null) {
                    String string = PropertyManager.getRuntimeProperty(INITIAL_SIZE_PROPERTY);
                    String string2 = PropertyManager.getRuntimeProperty(MAX_SIZE_PROPERTY);
                    String string3 = PropertyManager.getRuntimeProperty(INCREMENT_PROPERTY);
                    String string4 = PropertyManager.getRuntimeProperty(SYSTEM_MAX_SIZE_PROPERTY);
                    m_pool = new UDDIParserPool(string == null || string.length() == 0 ? 10 : Integer.parseInt(string), string2 == null || string2.length() == 0 ? 50 : Integer.parseInt(string2), string3 == null || string3.length() == 0 ? 2 : Integer.parseInt(string3), string4 == null || string4.length() == 0 ? 1000 : Integer.parseInt(string4));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.parserMap = new HashMap();
            }
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            throw new RuntimeException(UDDIMessages.get("error.operation.failed", "UDDIParserFactory"));
        }
        {
            Logger.trace("-UDDIParserFactory.CTOR()");
            return;
        }
    }

    public UDDIParser getUDDIParser() {
        Logger.trace("+UDDIParserFactory.getUDDIParser()");
        try {
            SOAPParser sOAPParser = this.m_parserFactory.createSOAPParser();
            DomBuilder domBuilder = this.m_parserFactory.createDOMParser(UDDI_SCHEMA_REF);
            domBuilder.setEntityResolver(new UDDIEntityResolver());
            UDDIParser uDDIParser = new UDDIParser(sOAPParser, domBuilder);
            Logger.trace("-UDDIParserFactory.getUDDIParser()");
            return uDDIParser;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(UDDIMessages.get("error.operation.failed", "getUDDIParser"));
        }
    }

    public void returnUDDIParser(UDDIParser uDDIParser) {
        Logger.trace("+UDDIParserFactory.returnUDDIParser()");
        Logger.trace("-UDDIParserFactory.returnUDDIParser()");
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 10;
        PropertyManager.setRuntimeProperty("uddi.schema.resource", "/weblogic/auddi/uddi/resources/uddi_v2.xsd");
        PropertyManager.setRuntimeProperty("soap.schema.resource", "/weblogic/auddi/uddi/resources/soap-envelope.xml");
        PropertyManager.setRuntimeProperty("xml.schema.resource", "/weblogic/auddi/uddi/resources/xml.xml");
        PropertyManager.setRuntimeProperty(INITIAL_SIZE_PROPERTY, "2");
        PropertyManager.setRuntimeProperty(MAX_SIZE_PROPERTY, "5");
        PropertyManager.setRuntimeProperty(INCREMENT_PROPERTY, "2");
        PropertyManager.setRuntimeProperty(SYSTEM_MAX_SIZE_PROPERTY, "10");
        UDDIParserFactory uDDIParserFactory = new UDDIParserFactory();
        Vector<UDDIParser> vector = new Vector<UDDIParser>();
        for (n = 0; n < n2; ++n) {
            vector.add(uDDIParserFactory.getUDDIParser());
        }
        for (n = 0; n < n2; ++n) {
            try {
                ((UDDIParser)vector.get(n)).parseFile("C:/Projects/Test/JAXP/Data/Find_Business.xml");
                continue;
            }
            catch (SchemaException schemaException) {
                schemaException.printStackTrace();
            }
        }
        for (n = 0; n < n2; ++n) {
            uDDIParserFactory.returnUDDIParser((UDDIParser)vector.get(n));
        }
    }
}

