/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.uddi.xml;

import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.xml.UDDIEntityResolver;
import weblogic.auddi.uddi.xml.UDDIParser;
import weblogic.auddi.uddi.xml.UDDIParserPooledItem;
import weblogic.auddi.util.ConnectException;
import weblogic.auddi.util.Connection;
import weblogic.auddi.util.ConnectionPool;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.DomBuilder;
import weblogic.auddi.xml.ParserFactory;
import weblogic.auddi.xml.SOAPParser;
import weblogic.auddi.xml.SchemaException;

class UDDIParserPool
extends ConnectionPool {
    private static int s_idNum = 0;
    private int m_systemMaxSize;
    private int m_increment;
    private int m_initialSize;
    private int m_maxSize;
    private ParserFactory m_parserFactory;

    public UDDIParserPool(int n, int n2, int n3, int n4) throws ConnectException {
        super("UDDIParserPool");
        Logger.trace("+UDDIParserPool.CTOR()");
        this.m_systemMaxSize = n4;
        this.m_increment = n3;
        this.m_initialSize = n;
        this.m_maxSize = n2;
        this.m_parserFactory = new ParserFactory();
        Logger.trace("-UDDIParserPool.CTOR()");
    }

    public int getPoolSystemMaxSize() {
        return this.m_systemMaxSize;
    }

    public int getPoolIncrement() {
        return this.m_increment;
    }

    public int getPoolInitialSize() {
        return this.m_initialSize;
    }

    public int getPoolMaxSize() {
        return this.m_maxSize;
    }

    public Connection getNewConnection() throws ConnectException {
        Logger.trace("+UDDIParserPool.getNewConnection()");
        try {
            SOAPParser sOAPParser = this.m_parserFactory.createSOAPParser();
            DomBuilder domBuilder = this.m_parserFactory.createDOMParser("/uddi_v2.xsd");
            domBuilder.setEntityResolver(new UDDIEntityResolver());
            UDDIParserPooledItem uDDIParserPooledItem = new UDDIParserPooledItem(new UDDIParser(sOAPParser, domBuilder), String.valueOf(++s_idNum));
            Logger.trace("-UDDIParserPool.getNewConnection(): BusySize: " + this.getBusySize() + " FreeSize: " + this.getFreeSize() + " SystemPoolSize: " + this.getSystemPoolSize() + " Counter: " + this.getCounter());
            return uDDIParserPooledItem;
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            throw new RuntimeException(UDDIMessages.get("error.operation.failed", "getNewConnection"));
        }
    }
}

